"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricExplorerSeriesChart = MetricExplorerSeriesChart;
exports.MetricsExplorerAreaChart = MetricsExplorerAreaChart;
exports.MetricsExplorerBarChart = MetricsExplorerBarChart;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _color_palette = require("../../../../common/custom_threshold_rule/color_palette");
var _types = require("../../../../common/custom_threshold_rule/types");
var _use_kibana_time_zone_setting = require("../hooks/use_kibana_time_zone_setting");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MetricExplorerSeriesChart(props) {
  if (_types.MetricsExplorerChartType.bar === props.type) {
    return /*#__PURE__*/_react.default.createElement(MetricsExplorerBarChart, props);
  }
  return /*#__PURE__*/_react.default.createElement(MetricsExplorerAreaChart, props);
}
function MetricsExplorerAreaChart({
  name,
  color,
  id,
  series,
  type,
  stack,
  opacity
}) {
  const timezone = (0, _use_kibana_time_zone_setting.useKibanaTimeZoneSetting)();
  const seriesColor = color && (0, _color_palette.colorTransformer)(color) || (0, _color_palette.colorTransformer)(_color_palette.Color.color0);
  const yAccessors = Array.isArray(id) ? id.map(i => `metric_${i}`).slice(id.length - 1, id.length) : [`metric_${id}`];
  const y0Accessors = Array.isArray(id) && id.length > 1 ? id.map(i => `metric_${i}`).slice(0, 1) : undefined;
  const chartId = `series-${series.id}-${yAccessors.join('-')}`;
  const seriesAreaStyle = {
    line: {
      strokeWidth: 2,
      visible: true
    },
    area: {
      opacity: opacity || 0.5,
      visible: type === _types.MetricsExplorerChartType.area
    }
  };
  return /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: chartId,
    key: chartId,
    name: name,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "timestamp",
    yAccessors: yAccessors,
    y0Accessors: y0Accessors,
    data: series.rows,
    stackAccessors: stack ? ['timestamp'] : void 0,
    areaSeriesStyle: seriesAreaStyle,
    color: seriesColor,
    timeZone: timezone
  });
}
function MetricsExplorerBarChart({
  name,
  color,
  id,
  series,
  stack
}) {
  const timezone = (0, _use_kibana_time_zone_setting.useKibanaTimeZoneSetting)();
  const seriesColor = color && (0, _color_palette.colorTransformer)(color) || (0, _color_palette.colorTransformer)(_color_palette.Color.color0);
  const yAccessors = Array.isArray(id) ? id.map(i => `metric_${i}`).slice(id.length - 1, id.length) : [`metric_${id}`];
  const chartId = `series-${series.id}-${yAccessors.join('-')}`;
  const seriesBarStyle = {
    rectBorder: {
      stroke: seriesColor,
      strokeWidth: 1,
      visible: true
    },
    rect: {
      opacity: 1
    }
  };
  return /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: chartId,
    key: chartId,
    name: name,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "timestamp",
    yAccessors: yAccessors,
    data: series.rows,
    stackAccessors: stack ? ['timestamp'] : void 0,
    barSeriesStyle: seriesBarStyle,
    color: seriesColor,
    timeZone: timezone
  });
}