"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityOnboardingHeaderActionMenu = ObservabilityOnboardingHeaderActionMenu;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-shared-plugin/common");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ObservabilityOnboardingHeaderActionMenu() {
  const location = (0, _reactRouterDom.useLocation)();
  const normalizedPathname = location.pathname.replace(/\/$/, '');
  const isRootPage = normalizedPathname === '';
  if (!isRootPage) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "observabilityOnboardingPageGiveFeedback",
      href: _common.LOGS_ONBOARDING_FEEDBACK_LINK,
      size: "s",
      target: "_blank",
      color: "warning",
      iconType: "editorComment"
    }, _i18n.i18n.translate('xpack.observability_onboarding.header.feedback', {
      defaultMessage: 'Give feedback'
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
}