"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Inspect = Inspect;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _step_panel = require("../../shared/step_panel");
var _ = require(".");
var _back_button = require("../../shared/back_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Inspect() {
  const {
    goBack,
    getState,
    getPath,
    getUsage
  } = (0, _.useWizard)();
  return /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
    title: "Inspect wizard",
    panelFooter: /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelFooter, {
      items: [/*#__PURE__*/_react.default.createElement(_back_button.BackButton, {
        onBack: goBack
      })]
    })
  }, /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.observability_onboarding.inspect.h3.stateLabel', {
    defaultMessage: 'State'
  }))), /*#__PURE__*/_react.default.createElement("pre", null, JSON.stringify(getState(), null, 4)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.inspect.h3.pathLabel",
    defaultMessage: "Path"
  }))), /*#__PURE__*/_react.default.createElement("pre", null, JSON.stringify(getPath(), null, 4)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.observability_onboarding.inspect.h3.usageLabel', {
    defaultMessage: 'Usage'
  }))), /*#__PURE__*/_react.default.createElement("pre", null, JSON.stringify(getUsage(), null, 4))));
}