"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRoleTranslation = getRoleTranslation;
var _i18n = require("@kbn/i18n");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getRoleTranslation(role) {
  if (role === _common.MessageRole.User) {
    return _i18n.i18n.translate('xpack.observabilityAiAssistant.chatTimeline.messages.user.label', {
      defaultMessage: 'You'
    });
  }
  if (role === _common.MessageRole.System) {
    return _i18n.i18n.translate('xpack.observabilityAiAssistant.chatTimeline.messages.system.label', {
      defaultMessage: 'System'
    });
  }
  return _i18n.i18n.translate('xpack.observabilityAiAssistant.chatTimeline.messages.elasticAssistant.label', {
    defaultMessage: 'Elastic Assistant'
  });
}