"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PromptEditorNaturalLanguage = PromptEditorNaturalLanguage;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("../../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PromptEditorNaturalLanguage({
  disabled,
  prompt,
  onChange,
  onChangeHeight,
  onFocus,
  onBlur
}) {
  const textAreaRef = (0, _react.useRef)(null);
  const handleChange = event => {
    handleResizeTextArea();
    onChange({
      role: _common.MessageRole.User,
      content: event.currentTarget.value
    });
  };
  const handleResizeTextArea = (0, _react.useCallback)(() => {
    var _textAreaRef$current2;
    if (textAreaRef.current) {
      var _textAreaRef$current;
      textAreaRef.current.style.minHeight = 'auto';
      textAreaRef.current.style.minHeight = ((_textAreaRef$current = textAreaRef.current) === null || _textAreaRef$current === void 0 ? void 0 : _textAreaRef$current.scrollHeight) + 'px';
    }
    if ((_textAreaRef$current2 = textAreaRef.current) !== null && _textAreaRef$current2 !== void 0 && _textAreaRef$current2.scrollHeight) {
      onChangeHeight(textAreaRef.current.scrollHeight);
    }
  }, [onChangeHeight]);
  (0, _react.useEffect)(() => {
    const textarea = textAreaRef.current;
    if (textarea) {
      textarea.focus();
    }
  }, [handleResizeTextArea]);
  (0, _react.useEffect)(() => {
    handleResizeTextArea();
  }, [handleResizeTextArea]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    "data-test-subj": "observabilityAiAssistantChatPromptEditorTextArea",
    css: {
      maxHeight: 200
    },
    disabled: disabled,
    fullWidth: true,
    inputRef: textAreaRef,
    placeholder: _i18n.i18n.translate('xpack.observabilityAiAssistant.prompt.placeholder', {
      defaultMessage: 'Send a message to the Assistant'
    }),
    resize: "vertical",
    rows: 1,
    value: prompt || '',
    onChange: handleChange,
    onFocus: onFocus,
    onBlur: onBlur
  });
}