"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WelcomeMessageConnectors = WelcomeMessageConnectors;
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _coreHttpBrowser = require("@kbn/core-http-browser");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fadeInAnimation = (0, _css.keyframes)`
  from {
    opacity: 0;
  }
  to {
    opacity: 1;
  }
`;
const fadeInClassName = (0, _css.css)`
  animation: ${fadeInAnimation} ${_uiTheme.euiThemeVars.euiAnimSpeedNormal} ease-in-out;
`;
function WelcomeMessageConnectors({
  connectors,
  onSetupConnectorClick
}) {
  var _connectors$connector;
  if (connectors.error) {
    const isForbiddenError = (0, _coreHttpBrowser.isHttpFetchError)(connectors.error) && connectors.error.body.statusCode === 403;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: fadeInClassName
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center",
      justifyContent: "center",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "alert",
      color: "danger"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "danger"
    }, isForbiddenError ? _i18n.i18n.translate('xpack.observabilityAiAssistant.welcomeMessageConnectors.connectorsForbiddenTextLabel', {
      defaultMessage: 'Required privileges to get connectors are missing'
    }) : _i18n.i18n.translate('xpack.observabilityAiAssistant.welcomeMessageConnectors.connectorsErrorTextLabel', {
      defaultMessage: 'Could not load connectors'
    })))));
  }
  return !connectors.loading && ((_connectors$connector = connectors.connectors) === null || _connectors$connector === void 0 ? void 0 : _connectors$connector.length) === 0 && onSetupConnectorClick ? /*#__PURE__*/_react.default.createElement("div", {
    className: fadeInClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.initialSetupPanel.setupConnector.description2', {
    defaultMessage: 'Start working with the Elastic AI Assistant by setting up a connector for your AI provider. The OpenAI model needs to support function calls. We strongly recommend using GPT4.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: "",
    css: {
      boxShadow: 'none',
      inlineSize: 'unset',
      lineHeight: 'initial'
    },
    tooltipContent: _i18n.i18n.translate('xpack.observabilityAiAssistant.technicalPreviewBadgeDescription', {
      defaultMessage: "GPT4 is required for a more consistent experience when using function calls (for example when performing root cause analysis, visualizing data and more). GPT3.5 can work for some of the simpler workflows, such as explaining errors or for a ChatGPT like experience within Kibana which don't require the use of frequent function calls."
    }),
    iconType: "iInCircle",
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "observabilityAiAssistantInitialSetupPanelSetUpGenerativeAiConnectorButton",
    fill: true,
    color: "primary",
    onClick: onSetupConnectorClick
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.initialSetupPanel.setupConnector.buttonLabel', {
    defaultMessage: 'Set up GenAI connector'
  })))) : null;
}