"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WelcomeMessage = WelcomeMessage;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/actions-plugin/common");
var _elastic_ai_assistant = _interopRequireDefault(require("../../assets/elastic_ai_assistant.png"));
var _disclaimer = require("./disclaimer");
var _welcome_message_connectors = require("./welcome_message_connectors");
var _welcome_message_knowledge_base = require("./welcome_message_knowledge_base");
var _use_kibana = require("../../hooks/use_kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fullHeightClassName = (0, _css.css)`
  height: 100%;
`;
const centerMaxWidthClassName = (0, _css.css)`
  max-width: 600px;
  text-align: center;
`;
function WelcomeMessage({
  connectors,
  knowledgeBase
}) {
  const breakpoint = (0, _eui.useCurrentEuiBreakpoint)();
  const {
    application: {
      navigateToApp,
      capabilities
    },
    plugins: {
      start: {
        triggersActionsUi: {
          getAddConnectorFlyout: ConnectorFlyout
        }
      }
    }
  } = (0, _use_kibana.useKibana)().services;
  const [connectorFlyoutOpen, setConnectorFlyoutOpen] = (0, _react.useState)(false);
  const handleConnectorClick = () => {
    var _capabilities$managem, _capabilities$managem2;
    if ((_capabilities$managem = capabilities.management) !== null && _capabilities$managem !== void 0 && (_capabilities$managem2 = _capabilities$managem.insightsAndAlerting) !== null && _capabilities$managem2 !== void 0 && _capabilities$managem2.triggersActions) {
      setConnectorFlyoutOpen(true);
    } else {
      navigateToApp('management', {
        path: '/insightsAndAlerting/triggersActionsConnectors/connectors'
      });
    }
  };
  const onConnectorCreated = createdConnector => {
    var _knowledgeBase$status;
    setConnectorFlyoutOpen(false);
    if (createdConnector.actionTypeId === '.gen-ai') {
      connectors.reloadConnectors();
    }
    if (!knowledgeBase.status.value || ((_knowledgeBase$status = knowledgeBase.status.value) === null || _knowledgeBase$status === void 0 ? void 0 : _knowledgeBase$status.ready) === false) {
      knowledgeBase.install();
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "column",
    gutterSize: "none",
    className: fullHeightClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: centerMaxWidthClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: breakpoint === 'xl' ? 'l' : 'l' ? 'l' : 's'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    src: _elastic_ai_assistant.default,
    alt: "Elastic AI Assistant",
    size: breakpoint === 'xl' ? 300 : 'm'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: breakpoint === 'xl' ? 'm' : 'l' ? 'm' : 's'
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.observabilityAiAssistant.disclaimer.title', {
    defaultMessage: 'Welcome to the AI Assistant for Observability'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_welcome_message_connectors.WelcomeMessageConnectors, {
    connectors: connectors,
    onSetupConnectorClick: handleConnectorClick
  }), /*#__PURE__*/_react.default.createElement(_welcome_message_knowledge_base.WelcomeMessageKnowledgeBase, {
    connectors: connectors,
    knowledgeBase: knowledgeBase
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_disclaimer.Disclaimer, null))), connectorFlyoutOpen ? /*#__PURE__*/_react.default.createElement(ConnectorFlyout, {
    featureId: _common.GenerativeAIForObservabilityConnectorFeatureId,
    onConnectorCreated: onConnectorCreated,
    onClose: () => setConnectorFlyoutOpen(false)
  }) : null);
}