"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FunctionListPopover = FunctionListPopover;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _types = require("../../../common/types");
var _use_observability_ai_assistant_chat_service = require("../../hooks/use_observability_ai_assistant_chat_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FunctionListPopover({
  mode,
  selectedFunctionName,
  onSelectFunction,
  disabled
}) {
  const {
    getFunctions
  } = (0, _use_observability_ai_assistant_chat_service.useObservabilityAIAssistantChatService)();
  const functions = getFunctions();
  const [functionOptions, setFunctionOptions] = (0, _react.useState)(mapFunctions({
    functions,
    selectedFunctionName
  }));
  const [isFunctionListOpen, setIsFunctionListOpen] = (0, _react.useState)(false);
  const handleClickFunctionList = () => {
    if (selectedFunctionName) {
      onSelectFunction(undefined);
      setIsFunctionListOpen(false);
      return;
    }
    setIsFunctionListOpen(!isFunctionListOpen);
  };
  const handleSelectFunction = func => {
    setIsFunctionListOpen(false);
    onSelectFunction(func.label);
  };
  (0, _react.useEffect)(() => {
    const options = mapFunctions({
      functions,
      selectedFunctionName
    });
    if (options.length !== functionOptions.length) {
      setFunctionOptions(options);
    }
  }, [functionOptions.length, functions, selectedFunctionName]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      key: mode // this is added to prevent the tooltip from flickering when the mode stays the same
      ,
      content: mode === 'prompt' ? _i18n.i18n.translate('xpack.observabilityAiAssistant.functionListPopover.euiToolTip.selectAFunctionLabel', {
        defaultMessage: 'Select a function'
      }) : _i18n.i18n.translate('xpack.observabilityAiAssistant.functionListPopover.euiToolTip.clearFunction', {
        defaultMessage: 'Clear function'
      }),
      display: "block"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.functionListPopover.euiButtonIcon.selectAFunctionLabel', {
        defaultMessage: 'Select function'
      }),
      "data-test-subj": "observabilityAiAssistantFunctionListPopoverButton",
      disabled: disabled,
      iconType: selectedFunctionName ? 'cross' : 'plusInCircle',
      size: "xs",
      onClick: handleClickFunctionList
    })),
    closePopover: handleClickFunctionList,
    css: {
      maxWidth: 400
    },
    initialFocus: "#searchFilterList",
    panelPaddingSize: "none",
    isOpen: isFunctionListOpen
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.prompt.functionList.functionList', {
      defaultMessage: 'Function list'
    }),
    listProps: {
      isVirtualized: false,
      showIcons: false
    },
    options: functionOptions,
    renderOption: renderFunctionOption,
    searchable: true,
    searchProps: {
      'data-test-subj': 'searchFiltersList',
      id: 'searchFilterList',
      placeholder: _i18n.i18n.translate('xpack.observabilityAiAssistant.prompt.functionList.filter', {
        defaultMessage: 'Filter'
      })
    },
    singleSelection: true,
    onChange: options => {
      const selectedFunction = options.filter(fn => !('checked' in fn));
      if (selectedFunction && selectedFunction.length === 1) {
        handleSelectFunction({
          ...selectedFunction[0],
          checked: 'on'
        });
      }
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      overflow: 'hidden'
    }
  }, search, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 500,
      height: 350,
      overflowY: 'scroll'
    }
  }, list))));
}
function mapFunctions({
  functions,
  selectedFunctionName
}) {
  return functions.filter(func => func.visibility !== _types.FunctionVisibility.System).map(func => ({
    label: func.name,
    searchableLabel: func.descriptionForUser || func.description,
    checked: func.name === selectedFunctionName ? 'on' : 'off'
  }));
}
function renderFunctionOption(option, searchValue) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
    search: searchValue
  }, option.label), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: "beta",
    size: "s",
    style: {
      verticalAlign: 'middle'
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    style: {
      textOverflow: 'ellipsis',
      overflow: 'hidden',
      marginBottom: 4
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
    search: searchValue
  }, option.searchableLabel || ''))));
}