"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatItemControls = ChatItemControls;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _feedback_buttons = require("../feedback_buttons");
var _regenerate_response_button = require("../buttons/regenerate_response_button");
var _stop_generating_button = require("../buttons/stop_generating_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const containerClassName = (0, _css.css)`
  padding-top: 4px;
  padding-bottom: 4px;
`;
function ChatItemControls({
  error,
  loading,
  canRegenerate,
  canGiveFeedback,
  onFeedbackClick,
  onRegenerateClick,
  onStopGeneratingClick
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const displayFeedback = !error && canGiveFeedback;
  const displayRegenerate = !loading && canRegenerate;
  let controls;
  if (loading) {
    controls = /*#__PURE__*/_react.default.createElement(_stop_generating_button.StopGeneratingButton, {
      onClick: onStopGeneratingClick
    });
  } else if (displayFeedback || displayRegenerate) {
    controls = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      alignItems: "center"
    }, displayFeedback ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_feedback_buttons.FeedbackButtons, {
      onClickFeedback: onFeedbackClick
    })) : null, displayRegenerate ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_regenerate_response_button.RegenerateResponseButton, {
      onClick: onRegenerateClick
    })) : null);
  } else {
    controls = null;
  }
  return controls ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    color: euiTheme.colors.lightestShade
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "s",
    className: containerClassName
  }, controls)) : null;
}