"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatBody = ChatBody;
exports.reverseToLastUserMessage = reverseToLastUserMessage;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _use_chat = require("../../hooks/use_chat");
var _use_conversation = require("../../hooks/use_conversation");
var _use_license = require("../../hooks/use_license");
var _use_observability_ai_assistant_chat_service = require("../../hooks/use_observability_ai_assistant_chat_service");
var _types = require("../../../common/types");
var _chat_header = require("./chat_header");
var _prompt_editor = require("../prompt_editor/prompt_editor");
var _chat_timeline = require("./chat_timeline");
var _incorrect_license_panel = require("./incorrect_license_panel");
var _welcome_message = require("./welcome_message");
var _i18n2 = require("../../i18n");
var _types2 = require("./types");
var _analytics = require("../../analytics");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fullHeightClassName = (0, _css.css)`
  height: 100%;
`;
const timelineClassName = (0, _css.css)`
  overflow-y: auto;
`;
const promptEditorClassname = (0, _css.css)`
  overflow: hidden;
  transition: height ${_uiTheme.euiThemeVars.euiAnimSpeedFast} ${_uiTheme.euiThemeVars.euiAnimSlightResistance};
`;
const incorrectLicenseContainer = (0, _css.css)`
  height: 100%;
  padding: ${_uiTheme.euiThemeVars.euiPanelPaddingModifiers.paddingMedium};
`;
const chatBodyContainerClassNameWithError = (0, _css.css)`
  align-self: center;
`;
const promptEditorContainerClassName = (0, _css.css)`
  padding-top: 12px;
  padding-bottom: 8px;
`;
const fadeInAnimation = (0, _css.keyframes)`
  from {
    opacity: 0;
    transform: scale(0.9);
  }
  to {
    opacity: 1;
    transform: scale(1);
  }
`;
const animClassName = (0, _css.css)`
  height: 100%;
  opacity: 0;
  animation: ${fadeInAnimation} ${_uiTheme.euiThemeVars.euiAnimSpeedNormal}
    ${_uiTheme.euiThemeVars.euiAnimSlightBounce} ${_uiTheme.euiThemeVars.euiAnimSpeedNormal} forwards;
`;
const PADDING_AND_BORDER = 32;
function ChatBody({
  initialTitle,
  initialMessages,
  initialConversationId,
  connectors,
  knowledgeBase,
  connectorsManagementHref,
  currentUser,
  startedFrom,
  onConversationUpdate
}) {
  var _conversation$value2, _conversation$value3;
  const license = (0, _use_license.useLicense)();
  const hasCorrectLicense = license === null || license === void 0 ? void 0 : license.hasAtLeast('enterprise');
  const chatService = (0, _use_observability_ai_assistant_chat_service.useObservabilityAIAssistantChatService)();
  const {
    conversation,
    messages,
    next,
    state,
    stop,
    saveTitle
  } = (0, _use_conversation.useConversation)({
    initialConversationId,
    initialMessages,
    initialTitle,
    chatService,
    connectorId: connectors.selectedConnector,
    onConversationUpdate
  });
  const timelineContainerRef = (0, _react.useRef)(null);
  let footer;
  const isLoading = Boolean(connectors.loading || knowledgeBase.status.loading || state === _use_chat.ChatState.Loading || conversation.loading);
  const containerClassName = (0, _css.css)`
    max-height: 100%;
    max-width: ${startedFrom === 'conversationView' ? 1200 - 250 + 'px' // page template max width - conversation list width.
  : '100%'};
  `;
  const [stickToBottom, setStickToBottom] = (0, _react.useState)(true);
  const isAtBottom = parent => parent.scrollTop + parent.clientHeight >= parent.scrollHeight;
  const [promptEditorHeight, setPromptEditorHeight] = (0, _react.useState)(0);
  const handleFeedback = (message, feedback) => {
    var _conversation$value;
    if ((_conversation$value = conversation.value) !== null && _conversation$value !== void 0 && _conversation$value.conversation && 'user' in conversation.value) {
      (0, _analytics.sendEvent)(chatService.analytics, {
        type: _analytics.TELEMETRY.observability_ai_assistant_chat_feedback,
        payload: {
          messageWithFeedback: {
            message,
            feedback
          },
          conversation: conversation.value
        }
      });
    }
  };
  const handleChangeHeight = editorHeight => {
    if (editorHeight === 0) {
      setPromptEditorHeight(0);
    } else {
      setPromptEditorHeight(editorHeight + PADDING_AND_BORDER);
    }
  };
  (0, _react.useEffect)(() => {
    var _timelineContainerRef;
    const parent = (_timelineContainerRef = timelineContainerRef.current) === null || _timelineContainerRef === void 0 ? void 0 : _timelineContainerRef.parentElement;
    if (!parent) {
      return;
    }
    function onScroll() {
      setStickToBottom(isAtBottom(parent));
    }
    parent.addEventListener('scroll', onScroll);
    return () => {
      parent.removeEventListener('scroll', onScroll);
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [timelineContainerRef.current]);
  (0, _react.useEffect)(() => {
    var _timelineContainerRef2;
    const parent = (_timelineContainerRef2 = timelineContainerRef.current) === null || _timelineContainerRef2 === void 0 ? void 0 : _timelineContainerRef2.parentElement;
    if (!parent) {
      return;
    }
    if (stickToBottom) {
      parent.scrollTop = parent.scrollHeight;
    }
  });
  const handleCopyConversation = () => {
    var _navigator$clipboard;
    const content = JSON.stringify({
      title: initialTitle,
      messages
    });
    (_navigator$clipboard = navigator.clipboard) === null || _navigator$clipboard === void 0 ? void 0 : _navigator$clipboard.writeText(content || '');
  };
  if (!hasCorrectLicense && !initialConversationId) {
    var _connectors$connector;
    footer = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      className: incorrectLicenseContainer
    }, /*#__PURE__*/_react.default.createElement(_incorrect_license_panel.IncorrectLicensePanel, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: false,
      hasShadow: false,
      paddingSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_prompt_editor.PromptEditor, {
      hidden: connectors.loading || ((_connectors$connector = connectors.connectors) === null || _connectors$connector === void 0 ? void 0 : _connectors$connector.length) === 0,
      loading: isLoading,
      disabled: true,
      onChangeHeight: setPromptEditorHeight,
      onSubmit: message => {
        next(messages.concat(message));
      },
      onSendTelemetry: eventWithPayload => (0, _analytics.sendEvent)(chatService.analytics, eventWithPayload)
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }))));
  } else if (!conversation.value && conversation.loading) {
    footer = null;
  } else {
    var _connectors$connector2, _connectors$connector3, _connectors$connector4;
    footer = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      className: timelineClassName
    }, /*#__PURE__*/_react.default.createElement("div", {
      ref: timelineContainerRef,
      className: fullHeightClassName
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      grow: true,
      hasBorder: false,
      hasShadow: false,
      paddingSize: "m",
      className: animClassName
    }, ((_connectors$connector2 = connectors.connectors) === null || _connectors$connector2 === void 0 ? void 0 : _connectors$connector2.length) === 0 || messages.length === 1 ? /*#__PURE__*/_react.default.createElement(_welcome_message.WelcomeMessage, {
      connectors: connectors,
      knowledgeBase: knowledgeBase
    }) : /*#__PURE__*/_react.default.createElement(_chat_timeline.ChatTimeline, {
      startedFrom: startedFrom,
      messages: messages,
      knowledgeBase: knowledgeBase,
      chatService: chatService,
      currentUser: currentUser,
      chatState: state,
      hasConnector: !!((_connectors$connector3 = connectors.connectors) !== null && _connectors$connector3 !== void 0 && _connectors$connector3.length),
      onEdit: (editedMessage, newMessage) => {
        setStickToBottom(true);
        const indexOf = messages.indexOf(editedMessage);
        next(messages.slice(0, indexOf).concat(newMessage));
      },
      onFeedback: handleFeedback,
      onRegenerate: message => {
        next(reverseToLastUserMessage(messages, message));
      },
      onSendTelemetry: eventWithPayload => (0, _analytics.sendEvent)(chatService.analytics, eventWithPayload),
      onStopGenerating: () => {
        stop();
      },
      onActionClick: payload => {
        setStickToBottom(true);
        switch (payload.type) {
          case _types2.ChatActionClickType.executeEsqlQuery:
            next(messages.concat({
              '@timestamp': new Date().toISOString(),
              message: {
                role: _types.MessageRole.Assistant,
                content: '',
                function_call: {
                  name: 'execute_query',
                  arguments: JSON.stringify({
                    query: payload.query
                  }),
                  trigger: _types.MessageRole.User
                }
              }
            }));
            break;
        }
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: promptEditorClassname,
      style: {
        height: promptEditorHeight
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: false,
      hasShadow: false,
      paddingSize: "m",
      color: "subdued",
      className: promptEditorContainerClassName
    }, /*#__PURE__*/_react.default.createElement(_prompt_editor.PromptEditor, {
      disabled: !connectors.selectedConnector || !hasCorrectLicense,
      hidden: connectors.loading || ((_connectors$connector4 = connectors.connectors) === null || _connectors$connector4 === void 0 ? void 0 : _connectors$connector4.length) === 0,
      loading: isLoading,
      onChangeHeight: handleChangeHeight,
      onSendTelemetry: eventWithPayload => (0, _analytics.sendEvent)(chatService.analytics, eventWithPayload),
      onSubmit: message => {
        setStickToBottom(true);
        return next(messages.concat(message));
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }))));
  }
  if (conversation.error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      className: containerClassName,
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: chatBodyContainerClassNameWithError
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      title: _i18n.i18n.translate('xpack.observabilityAiAssistant.couldNotFindConversationTitle', {
        defaultMessage: 'Conversation not found'
      }),
      iconType: "warning"
    }, _i18n.i18n.translate('xpack.observabilityAiAssistant.couldNotFindConversationContent', {
      defaultMessage: 'Could not find a conversation with id {conversationId}. Make sure the conversation exists and you have access to it.',
      values: {
        conversationId: initialConversationId
      }
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    className: containerClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: conversation.error ? chatBodyContainerClassNameWithError : undefined
  }, conversation.error ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    title: _i18n.i18n.translate('xpack.observabilityAiAssistant.couldNotFindConversationTitle', {
      defaultMessage: 'Conversation not found'
    }),
    iconType: "warning"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.couldNotFindConversationContent', {
    defaultMessage: 'Could not find a conversation with id {conversationId}. Make sure the conversation exists and you have access to it.',
    values: {
      conversationId: initialConversationId
    }
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_chat_header.ChatHeader, {
    connectors: connectors,
    conversationId: (_conversation$value2 = conversation.value) !== null && _conversation$value2 !== void 0 && _conversation$value2.conversation && 'id' in conversation.value.conversation ? conversation.value.conversation.id : undefined,
    connectorsManagementHref: connectorsManagementHref,
    knowledgeBase: knowledgeBase,
    licenseInvalid: !hasCorrectLicense && !initialConversationId,
    loading: isLoading,
    startedFrom: startedFrom,
    title: ((_conversation$value3 = conversation.value) === null || _conversation$value3 === void 0 ? void 0 : _conversation$value3.conversation.title) || initialTitle || _i18n2.EMPTY_CONVERSATION_TITLE,
    onCopyConversation: handleCopyConversation,
    onSaveTitle: newTitle => {
      saveTitle(newTitle);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), footer);
}

// Exported for testing only
function reverseToLastUserMessage(messages, message) {
  // Drop messages after and including the one marked for regeneration
  const indexOf = messages.indexOf(message);
  const previousMessages = messages.slice(0, indexOf);

  // Go back to the last written user message to fully regenerate function calls
  const lastUserMessageIndex = (0, _lodash.findLastIndex)(previousMessages, aMessage => aMessage.message.role === 'user' && !aMessage.message.name);
  const nextMessages = previousMessages.slice(0, lastUserMessageIndex + 1);
  return nextMessages;
}