"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.insightFeedbackEventSchema = exports.eventType = void 0;
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const eventType = 'observability_ai_assistant_insight_feedback';
exports.eventType = eventType;
const insightFeedbackEventSchema = {
  eventType,
  schema: {
    feedback: {
      type: 'text',
      _meta: {
        description: 'Whether the user has deemed this response useful or not'
      }
    },
    message: {
      properties: _common.messageSchema
    }
  }
};
exports.insightFeedbackEventSchema = insightFeedbackEventSchema;