"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.messageSchema = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const messageSchema = {
  '@timestamp': {
    type: 'text',
    _meta: {
      description: 'The timestamp of the message.'
    }
  },
  message: {
    properties: {
      content: {
        type: 'text',
        _meta: {
          description: 'The response generated by the LLM.',
          optional: true
        }
      },
      name: {
        type: 'text',
        _meta: {
          description: 'The name of the function that was executed.',
          optional: true
        }
      },
      role: {
        type: 'text',
        _meta: {
          description: 'The actor that generated the response.'
        }
      },
      data: {
        type: 'text',
        _meta: {
          description: '',
          optional: true
        }
      },
      function_call: {
        _meta: {
          description: 'The function call that was executed.',
          optional: true
        },
        properties: {
          name: {
            type: 'text',
            _meta: {
              description: 'The name of the function that was executed.',
              optional: false
            }
          },
          arguments: {
            type: 'text',
            _meta: {
              description: 'The arguments that were used when executing the function.',
              optional: true
            }
          },
          trigger: {
            type: 'text',
            _meta: {
              description: 'The actor which triggered the execution of this function.'
            }
          }
        }
      }
    }
  }
};
exports.messageSchema = messageSchema;