"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamingChatResponseEventType = exports.ConversationNotFoundError = exports.ConversationCompletionError = exports.ChatCompletionErrorCode = void 0;
exports.isChatCompletionError = isChatCompletionError;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable max-classes-per-file*/
let StreamingChatResponseEventType;
exports.StreamingChatResponseEventType = StreamingChatResponseEventType;
(function (StreamingChatResponseEventType) {
  StreamingChatResponseEventType["ChatCompletionChunk"] = "chatCompletionChunk";
  StreamingChatResponseEventType["ConversationCreate"] = "conversationCreate";
  StreamingChatResponseEventType["ConversationUpdate"] = "conversationUpdate";
  StreamingChatResponseEventType["MessageAdd"] = "messageAdd";
  StreamingChatResponseEventType["ConversationCompletionError"] = "conversationCompletionError";
})(StreamingChatResponseEventType || (exports.StreamingChatResponseEventType = StreamingChatResponseEventType = {}));
let ChatCompletionErrorCode;
exports.ChatCompletionErrorCode = ChatCompletionErrorCode;
(function (ChatCompletionErrorCode) {
  ChatCompletionErrorCode["InternalError"] = "internalError";
  ChatCompletionErrorCode["NotFound"] = "notFound";
})(ChatCompletionErrorCode || (exports.ChatCompletionErrorCode = ChatCompletionErrorCode = {}));
class ConversationCompletionError extends Error {
  constructor(code, message) {
    super(message);
    (0, _defineProperty2.default)(this, "code", void 0);
    this.code = code;
  }
}
exports.ConversationCompletionError = ConversationCompletionError;
class ConversationNotFoundError extends ConversationCompletionError {
  constructor() {
    super(ChatCompletionErrorCode.NotFound, _i18n.i18n.translate('xpack.observabilityAiAssistant.conversationCompletionError.conversationNotFound', {
      defaultMessage: 'Conversation not found'
    }));
  }
}
exports.ConversationNotFoundError = ConversationNotFoundError;
function isChatCompletionError(error) {
  return error instanceof ConversationCompletionError;
}