"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaOverviewPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _kibana_template = require("./kibana_template");
var _global_state_context = require("../../contexts/global_state_context");
var _chart = require("../../../components/chart");
var _cluster_status = require("../../../components/kibana/cluster_status");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _use_charts = require("../../hooks/use_charts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KibanaOverview = ({
  data
}) => {
  const {
    zoomInfo,
    onBrush
  } = (0, _use_charts.useCharts)();
  if (!data) return null;
  const showRules = data.metrics.kibana_cluster_rule_overdue_count && data.metrics.kibana_cluster_rule_overdue_count.length && data.metrics.kibana_cluster_rule_overdue_count[0].indices_found.ecs;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_cluster_status.ClusterStatus, {
    stats: data.clusterStatus
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, {
    series: data.metrics.kibana_cluster_requests,
    onBrush: onBrush,
    zoomInfo: zoomInfo
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, {
    series: data.metrics.kibana_cluster_response_times,
    onBrush: onBrush,
    zoomInfo: zoomInfo
  }))), showRules && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, {
    series: data.metrics.kibana_cluster_rule_overdue_count,
    onBrush: onBrush,
    zoomInfo: zoomInfo
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, {
    series: data.metrics.kibana_cluster_rule_overdue_duration,
    onBrush: onBrush,
    zoomInfo: zoomInfo
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, {
    series: data.metrics.kibana_cluster_action_overdue_count,
    onBrush: onBrush,
    zoomInfo: zoomInfo
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, {
    series: data.metrics.kibana_cluster_action_overdue_duration,
    onBrush: onBrush,
    zoomInfo: zoomInfo
  })))))));
};
const KibanaOverviewPage = ({
  clusters
}) => {
  var _services$data2;
  const globalState = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const {
    services
  } = (0, _public.useKibana)();
  const {
    generate: generateBreadcrumbs
  } = (0, _use_breadcrumbs.useBreadcrumbContainerContext)();
  const [data, setData] = (0, _react.useState)();
  const clusterUuid = globalState.cluster_uuid;
  const cluster = (0, _lodash.find)(clusters, {
    cluster_uuid: clusterUuid
  });
  const ccs = globalState.ccs;
  const title = _i18n.i18n.translate('xpack.monitoring.kibana.overview.title', {
    defaultMessage: 'Kibana'
  });
  const pageTitle = _i18n.i18n.translate('xpack.monitoring.kibana.overview.pageTitle', {
    defaultMessage: 'Kibana overview'
  });
  (0, _react.useEffect)(() => {
    if (cluster) {
      generateBreadcrumbs(cluster.cluster_name, {
        inKibana: true
      });
    }
  }, [cluster, generateBreadcrumbs]);
  const getPageData = (0, _react.useCallback)(async () => {
    var _services$data, _services$http;
    const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
    const url = `../api/monitoring/v1/clusters/${clusterUuid}/kibana`;
    const response = await ((_services$http = services.http) === null || _services$http === void 0 ? void 0 : _services$http.fetch(url, {
      method: 'POST',
      body: JSON.stringify({
        ccs,
        timeRange: {
          min: bounds.min.toISOString(),
          max: bounds.max.toISOString()
        }
      })
    }));
    setData(response);
  }, [ccs, clusterUuid, (_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter, services.http]);
  return /*#__PURE__*/_react.default.createElement(_kibana_template.KibanaTemplate, {
    getPageData: getPageData,
    title: title,
    pageTitle: pageTitle
  }, /*#__PURE__*/_react.default.createElement(KibanaOverview, {
    data: data
  }));
};
exports.KibanaOverviewPage = KibanaOverviewPage;