"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntSearchOverviewPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _public = require("@kbn/kibana-react-plugin/public");
var _ent_search_template = require("./ent_search_template");
var _global_state_context = require("../../contexts/global_state_context");
var _use_charts = require("../../hooks/use_charts");
var _overview = require("../../../components/enterprise_search/overview");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntSearchOverviewPage = ({
  clusters
}) => {
  var _services$data2;
  const globalState = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const {
    zoomInfo,
    onBrush
  } = (0, _use_charts.useCharts)();
  const {
    services
  } = (0, _public.useKibana)();
  const clusterUuid = globalState.cluster_uuid;
  const ccs = globalState.ccs;
  const {
    generate: generateBreadcrumbs
  } = (0, _use_breadcrumbs.useBreadcrumbContainerContext)();
  const cluster = (0, _lodash.find)(clusters, {
    cluster_uuid: clusterUuid
  });
  const [data, setData] = (0, _react.useState)(null);
  const title = _i18n.i18n.translate('xpack.monitoring.entSearch.overview.routeTitle', {
    defaultMessage: 'Enterprise Search - Overview'
  });
  const pageTitle = _i18n.i18n.translate('xpack.monitoring.entSearch.overview.pageTitle', {
    defaultMessage: 'Enterprise Search Overview'
  });
  (0, _react.useEffect)(() => {
    if (cluster) {
      generateBreadcrumbs(cluster.cluster_name, {
        inEnterpriseSearch: true
      });
    }
  }, [cluster, generateBreadcrumbs]);
  const getPageData = (0, _react.useCallback)(async () => {
    var _services$data, _services$http;
    const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
    const url = `../api/monitoring/v1/clusters/${clusterUuid}/enterprise_search`;
    const response = await ((_services$http = services.http) === null || _services$http === void 0 ? void 0 : _services$http.fetch(url, {
      method: 'POST',
      body: JSON.stringify({
        ccs,
        timeRange: {
          min: bounds.min.toISOString(),
          max: bounds.max.toISOString()
        }
      })
    }));
    setData(response);
  }, [ccs, clusterUuid, (_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter, services.http]);
  return /*#__PURE__*/_react.default.createElement(_ent_search_template.EntSearchTemplate, {
    title: title,
    pageTitle: pageTitle,
    getPageData: getPageData,
    "data-test-subj": "entSearchOverviewPage"
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "entSearchOverviewPage"
  },
  // @ts-expect-error ts upgrade v4.7.4
  data && /*#__PURE__*/_react.default.createElement(_overview.EnterpriseSearchOverview, (0, _extends2.default)({}, data, {
    onBrush: onBrush,
    zoomInfo: zoomInfo
  }))));
};
exports.EntSearchOverviewPage = EntSearchOverviewPage;