"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchMLJobsPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _public = require("@kbn/kibana-react-plugin/public");
var _elasticsearch_template = require("./elasticsearch_template");
var _global_state_context = require("../../contexts/global_state_context");
var _elasticsearch = require("../../../components/elasticsearch");
var _setup_mode = require("../../../components/renderers/setup_mode");
var _setup_mode_context = require("../../../components/setup_mode/setup_mode_context");
var _use_table = require("../../hooks/use_table");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _constants = require("../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElasticsearchMLJobsPage = ({
  clusters
}) => {
  var _services$data2;
  const globalState = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const {
    generate: generateBreadcrumbs
  } = (0, _use_breadcrumbs.useBreadcrumbContainerContext)();
  const {
    services
  } = (0, _public.useKibana)();
  const {
    getPaginationTableProps
  } = (0, _use_table.useTable)('elasticsearch.mlJobs');
  const clusterUuid = globalState.cluster_uuid;
  const ccs = globalState.ccs;
  const cluster = (0, _lodash.find)(clusters, {
    cluster_uuid: clusterUuid
  });
  (0, _react.useEffect)(() => {
    if (cluster) {
      generateBreadcrumbs(cluster.cluster_name, {
        inElasticsearch: true
      });
    }
  }, [cluster, generateBreadcrumbs]);
  const [data, setData] = (0, _react.useState)({});
  const title = _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobs.routeTitle', {
    defaultMessage: 'Elasticsearch - Machine Learning Jobs'
  });
  const pageTitle = _i18n.i18n.translate('xpack.monitoring.elasticsearch.mlJobs.pageTitle', {
    defaultMessage: 'Elasticsearch machine learning jobs'
  });
  const getPageData = (0, _react.useCallback)(async () => {
    var _services$data, _services$http, _response$rows;
    const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
    const url = `../api/monitoring/v1/clusters/${clusterUuid}/elasticsearch/ml_jobs`;
    const response = await ((_services$http = services.http) === null || _services$http === void 0 ? void 0 : _services$http.fetch(url, {
      method: 'POST',
      body: JSON.stringify({
        ccs,
        timeRange: {
          min: bounds.min.toISOString(),
          max: bounds.max.toISOString()
        }
      })
    }));
    setData({
      clusterStatus: response === null || response === void 0 ? void 0 : response.clusterStatus,
      jobs: response === null || response === void 0 ? void 0 : (_response$rows = response.rows) === null || _response$rows === void 0 ? void 0 : _response$rows.map(job => {
        var _job$ml;
        if ('ml' in job && (_job$ml = job.ml) !== null && _job$ml !== void 0 && _job$ml.job) {
          return {
            ...job.ml.job,
            node: job.node,
            job_id: job.ml.job.id
          };
        }
        return job;
      })
    });
  }, [ccs, clusterUuid, (_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter, services.http]);
  return /*#__PURE__*/_react.default.createElement(_elasticsearch_template.ElasticsearchTemplate, {
    title: title,
    pageTitle: pageTitle,
    getPageData: getPageData,
    "data-test-subj": "elasticsearchOverviewPage",
    cluster: cluster
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "elasticsearchMLJobsListingPage"
  }, /*#__PURE__*/_react.default.createElement(_setup_mode.SetupModeRenderer, {
    productName: _constants.ELASTICSEARCH_SYSTEM_ID,
    render: ({
      flyoutComponent,
      bottomBarComponent
    }) => /*#__PURE__*/_react.default.createElement(_setup_mode_context.SetupModeContext.Provider, {
      value: {
        setupModeSupported: true
      }
    }, flyoutComponent, /*#__PURE__*/_react.default.createElement(_elasticsearch.ElasticsearchMLJobs, (0, _extends2.default)({
      clusterStatus: data.clusterStatus,
      jobs: data.jobs
    }, getPaginationTableProps())), bottomBarComponent)
  })));
};
exports.ElasticsearchMLJobsPage = ElasticsearchMLJobsPage;