"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertsModal = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _use_request_error_handler = require("./use_request_error_handler");
var _alerts_toast = require("../../alerts/lib/alerts_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAlertsModal = () => {
  const {
    services
  } = (0, _public.useKibana)();
  const handleRequestError = (0, _use_request_error_handler.useRequestErrorHandler)();
  function shouldShowAlertsModal(alerts) {
    const modalHasBeenShown = window.sessionStorage.getItem('ALERTS_MODAL_HAS_BEEN_SHOWN') === 'true';
    const decisionMade = window.localStorage.getItem('ALERTS_MODAL_DECISION_MADE') === 'true';
    if (Object.keys(alerts).length > 0) {
      window.localStorage.setItem('ALERTS_MODAL_DECISION_MADE', 'true');
      return false;
    } else if (!modalHasBeenShown && !decisionMade) {
      return true;
    }
    return false;
  }
  async function enableAlerts() {
    try {
      var _services$http, _services$theme;
      if (!((_services$http = services.http) !== null && _services$http !== void 0 && _services$http.post)) {
        throw new Error('HTTP service is unavailable');
      }
      const response = await services.http.post('../api/monitoring/v1/alerts/enable', {});
      window.localStorage.setItem('ALERTS_MODAL_DECISION_MADE', 'true');
      (0, _alerts_toast.showAlertsToast)(response, (_services$theme = services.theme) === null || _services$theme === void 0 ? void 0 : _services$theme.theme$);
    } catch (err) {
      await handleRequestError(err);
    }
  }
  function notAskAgain() {
    window.localStorage.setItem('ALERTS_MODAL_DECISION_MADE', 'true');
  }
  function hideModalForSession() {
    window.sessionStorage.setItem('ALERTS_MODAL_HAS_BEEN_SHOWN', 'true');
  }
  return {
    shouldShowAlertsModal,
    enableAlerts,
    notAskAgain,
    hideModalForSession
  };
};
exports.useAlertsModal = useAlertsModal;