"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Expression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _alert_param_duration = require("../flyout_expressions/alert_param_duration");
var _enums = require("../../../common/enums");
var _alert_param_percentage = require("../flyout_expressions/alert_param_percentage");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Expression = props => {
  const {
    ruleParams,
    paramDetails,
    setRuleParams,
    errors
  } = props;
  const alertParamsUi = Object.keys(ruleParams).map(alertParamName => {
    const details = paramDetails[alertParamName];
    const value = ruleParams[alertParamName];
    switch (details === null || details === void 0 ? void 0 : details.type) {
      case _enums.AlertParamType.Duration:
        return /*#__PURE__*/_react.default.createElement(_alert_param_duration.AlertParamDuration, {
          key: alertParamName,
          name: alertParamName,
          duration: value,
          label: details.label,
          errors: errors[alertParamName],
          setRuleParams: setRuleParams
        });
      case _enums.AlertParamType.Percentage:
        return /*#__PURE__*/_react.default.createElement(_alert_param_percentage.AlertParamPercentage, {
          key: alertParamName,
          name: alertParamName,
          label: details.label,
          percentage: value,
          errors: errors[alertParamName],
          setRuleParams: setRuleParams
        });
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, alertParamsUi), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};

// for lazy loading
// eslint-disable-next-line import/no-default-export
exports.Expression = Expression;
var _default = Expression;
exports.default = _default;