"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.endsWithOpenBracket = endsWithOpenBracket;
exports.getDateMathOperation = getDateMathOperation;
exports.getDurationItemsWithQuantifier = getDurationItemsWithQuantifier;
exports.isDateFunction = isDateFunction;
var _autocomplete_definitions = require("./autocomplete_definitions");
var _date_math_expressions = require("./autocomplete_definitions/date_math_expressions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function endsWithOpenBracket(text) {
  return /\($/.test(text);
}
function isDateFunction(fnName) {
  // TODO: improve this and rely in signature in the future
  return ['to_datetime', 'date_trunc', 'date_parse'].includes(fnName.toLowerCase());
}
function getDateMathOperation() {
  return _autocomplete_definitions.mathOperatorsCommandsDefinitions.filter(({
    label
  }) => ['+', '-'].includes(String(label)));
}
function getDurationItemsWithQuantifier(quantifier = 1) {
  return _date_math_expressions.dateExpressionDefinitions.filter(({
    label
  }) => !/s$/.test(label.toString())).map(({
    label,
    insertText,
    ...rest
  }) => ({
    label: `${quantifier} ${label}`,
    insertText: `${quantifier} ${insertText}`,
    ...rest
  }));
}