"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withOperatorDefinition = exports.openBracketDefinition = exports.onOperatorDefinition = exports.mathOperatorsCommandsDefinitions = exports.closeBracketDefinition = exports.byOperatorDefinition = exports.assignOperatorDefinition = exports.asOperatorDefinition = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const byOperatorDefinition = {
  label: 'by',
  insertText: 'by',
  kind: 21,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.byDoc', {
    defaultMessage: 'By'
  }),
  sortText: 'D'
};
exports.byOperatorDefinition = byOperatorDefinition;
const onOperatorDefinition = {
  label: 'on',
  insertText: 'on',
  kind: 21,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.onDoc', {
    defaultMessage: 'On'
  }),
  sortText: 'D'
};
exports.onOperatorDefinition = onOperatorDefinition;
const withOperatorDefinition = {
  label: 'with',
  insertText: 'with',
  kind: 21,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.withDoc', {
    defaultMessage: 'With'
  }),
  sortText: 'D'
};
exports.withOperatorDefinition = withOperatorDefinition;
const asOperatorDefinition = {
  label: 'as',
  insertText: 'as',
  kind: 11,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.asDoc', {
    defaultMessage: 'As'
  }),
  sortText: 'D'
};
exports.asOperatorDefinition = asOperatorDefinition;
const assignOperatorDefinition = {
  label: '=',
  insertText: '=',
  kind: 11,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.assignDoc', {
    defaultMessage: 'Assign (=)'
  }),
  sortText: 'D'
};
exports.assignOperatorDefinition = assignOperatorDefinition;
const openBracketDefinition = {
  label: '(',
  insertText: '(',
  kind: 11,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.openBracketDoc', {
    defaultMessage: 'Open Bracket ('
  }),
  sortText: 'A'
};
exports.openBracketDefinition = openBracketDefinition;
const closeBracketDefinition = {
  label: ')',
  insertText: ')',
  kind: 11,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.closeBracketDoc', {
    defaultMessage: 'Close Bracket )'
  }),
  sortText: 'A'
};
exports.closeBracketDefinition = closeBracketDefinition;
const mathOperatorsCommandsDefinitions = [{
  label: '+',
  insertText: '+',
  kind: 11,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.addDoc', {
    defaultMessage: 'Add (+)'
  }),
  sortText: 'D'
}, {
  label: '-',
  insertText: '-',
  kind: 11,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.subtractDoc', {
    defaultMessage: 'Subtract (-)'
  }),
  sortText: 'D'
}, {
  label: '/',
  insertText: '/',
  kind: 11,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.divideDoc', {
    defaultMessage: 'Divide (/)'
  }),
  sortText: 'D'
}, {
  label: '*',
  insertText: '*',
  kind: 11,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.multiplyDoc', {
    defaultMessage: 'Multiply (*)'
  }),
  sortText: 'D'
}];
exports.mathOperatorsCommandsDefinitions = mathOperatorsCommandsDefinitions;