"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildSourcesDefinitions = exports.buildPoliciesDefinitions = exports.buildNoPoliciesAvailableDefinition = exports.buildNewVarDefinition = exports.buildMatchingFieldsDefinition = exports.buildFieldsDefinitions = exports.buildConstantsDefinitions = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const buildPoliciesDefinitions = policies => policies.map(({
  name: label,
  indices
}) => ({
  label,
  insertText: label,
  kind: 5,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.policyDefinition', {
    defaultMessage: `Policy defined on {count, plural, one {index} other {indices}}: {indices}`,
    values: {
      count: indices.length,
      indices: indices.join(', ')
    }
  }),
  sortText: 'D'
}));
exports.buildPoliciesDefinitions = buildPoliciesDefinitions;
const buildFieldsDefinitions = fields => fields.map(label => ({
  label,
  insertText: label,
  kind: 4,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.fieldDefinition', {
    defaultMessage: `Field specified by the input table`
  }),
  sortText: 'D'
}));
exports.buildFieldsDefinitions = buildFieldsDefinitions;
const buildNoPoliciesAvailableDefinition = () => [{
  label: _i18n.i18n.translate('monaco.esql.autocomplete.noPoliciesLabel', {
    defaultMessage: 'No available policy'
  }),
  insertText: '',
  kind: 26,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.noPoliciesLabelsFound', {
    defaultMessage: 'Click to create'
  }),
  sortText: 'D',
  command: {
    id: 'esql.policies.create',
    title: _i18n.i18n.translate('monaco.esql.autocomplete.createNewPolicy', {
      defaultMessage: 'Click to create'
    })
  }
}];
exports.buildNoPoliciesAvailableDefinition = buildNoPoliciesAvailableDefinition;
const buildMatchingFieldsDefinition = (matchingField, fields) => fields.map(label => ({
  label,
  insertText: label,
  kind: 4,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.matchingFieldDefinition', {
    defaultMessage: `Use to match on {matchingField} on the policy`,
    values: {
      matchingField
    }
  }),
  sortText: 'D'
}));
exports.buildMatchingFieldsDefinition = buildMatchingFieldsDefinition;
const buildNewVarDefinition = label => {
  return {
    label,
    insertText: label,
    kind: 21,
    detail: _i18n.i18n.translate('monaco.esql.autocomplete.newVarDoc', {
      defaultMessage: 'Define a new variable'
    }),
    sortText: 'D'
  };
};
exports.buildNewVarDefinition = buildNewVarDefinition;
const buildSourcesDefinitions = sources => sources.map(label => ({
  label,
  insertText: label,
  kind: 21,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.sourceDefinition', {
    defaultMessage: `Input table`
  }),
  sortText: 'A'
}));
exports.buildSourcesDefinitions = buildSourcesDefinitions;
const buildConstantsDefinitions = (userConstants, detail) => userConstants.map(label => ({
  label,
  insertText: label,
  kind: 14,
  detail: detail !== null && detail !== void 0 ? detail : _i18n.i18n.translate('monaco.esql.autocomplete.constantDefinition', {
    defaultMessage: `User defined variable`
  }),
  sortText: 'A'
}));
exports.buildConstantsDefinitions = buildConstantsDefinitions;