"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CompatibleLayer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _job_from_lens = require("../../../../../application/jobs/new_job/job_from_lens");
var _new_job = require("../../../../../../common/constants/new_job");
var _context = require("../../../common/context");
var _job_details = require("../../../common/job_details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// useCallback

const CompatibleLayer = ({
  layer,
  layerIndex,
  embeddable
}) => {
  const {
    services: {
      data,
      share,
      uiSettings,
      mlServices: {
        mlApiServices
      },
      lens,
      dashboardService
    }
  } = (0, _context.useMlFromLensKibanaContext)();
  const quickJobCreator = (0, _react.useMemo)(() => new _job_from_lens.QuickLensJobCreator(lens, uiSettings, data.query.timefilter.timefilter, dashboardService, mlApiServices),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [data, uiSettings]);
  function createADJobInWizard() {
    (0, _job_from_lens.redirectToADJobWizards)(embeddable, layerIndex, share, lens);
  }
  async function createADJob({
    jobId,
    bucketSpan,
    embeddable: lensEmbeddable,
    startJob,
    runInRealTime
  }) {
    const result = await quickJobCreator.createAndSaveJob(jobId, bucketSpan, lensEmbeddable, startJob, runInRealTime, layerIndex);
    return result;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_job_details.JobDetails, {
    createADJob: createADJob,
    createADJobInWizard: createADJobInWizard,
    embeddable: embeddable,
    timeRange: embeddable.getInput().timeRange,
    layer: layer,
    layerIndex: layerIndex
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    "data-test-subj": "mlLensLayerCompatible"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "checkInCircleFilled",
    color: "success"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, layer.jobType === _new_job.JOB_TYPE.MULTI_METRIC ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.embeddables.lensLayerFlyout.createJobCalloutTitle.multiMetric",
    defaultMessage: "This layer can be used to create a multi-metric job"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.embeddables.lensLayerFlyout.createJobCalloutTitle.singleMetric",
    defaultMessage: "This layer can be used to create a single metric job"
  }))))));
};
exports.CompatibleLayer = CompatibleLayer;