"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionEmbeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/embeddable-plugin/public");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AnomalyDetectionEmbeddable extends _public.Embeddable {
  // Need to defer embeddable load in order to resolve data views

  constructor(initialInput, anomalyDetectorService, dataViewsService, parent) {
    super(initialInput, {}, parent);
    (0, _defineProperty2.default)(this, "deferEmbeddableLoad", true);
    this.anomalyDetectorService = anomalyDetectorService;
    this.dataViewsService = dataViewsService;
    this.initializeOutput(initialInput).finally(() => {
      this.setInitializationFinished();
    });
  }
  async initializeOutput(initialInput) {
    const {
      jobIds
    } = initialInput;
    try {
      const jobs = await (0, _rxjs.firstValueFrom)(this.anomalyDetectorService.getJobs$(jobIds));

      // First get list of unique indices from the selected jobs
      const indices = new Set(jobs.map(j => j.datafeed_config.indices).flat());
      // Then find the data view assuming the data view title matches the index name
      const indexPatterns = {};
      for (const indexName of indices) {
        const response = await this.dataViewsService.find(`"${indexName}"`);
        const indexPattern = response.find(obj => obj.getIndexPattern().toLowerCase().includes(indexName.toLowerCase()));
        if (indexPattern !== undefined) {
          indexPatterns[indexPattern.id] = indexPattern;
        }
      }
      this.updateOutput({
        ...this.getOutput(),
        indexPatterns: Object.values(indexPatterns)
      });
    } catch (e) {
      // Unable to find and load data view but we can ignore the error
      // as we only load it to support the filter & query bar
      // the visualizations should still work correctly

      // eslint-disable-next-line no-console
      console.error(`Unable to load data views for ${jobIds}`, e);
    }
  }
}
exports.AnomalyDetectionEmbeddable = AnomalyDetectionEmbeddable;