"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clearCache = clearCache;
exports.getApplication = getApplication;
exports.getAutocomplete = getAutocomplete;
exports.getBasePath = getBasePath;
exports.getChrome = getChrome;
exports.getDashboard = getDashboard;
exports.getDataViews = getDataViews;
exports.getDocLinks = getDocLinks;
exports.getFieldFormats = getFieldFormats;
exports.getFileDataVisualizer = getFileDataVisualizer;
exports.getHttp = getHttp;
exports.getI18n = getI18n;
exports.getLens = getLens;
exports.getOverlays = getOverlays;
exports.getRecentlyAccessed = getRecentlyAccessed;
exports.getSecurity = getSecurity;
exports.getShare = getShare;
exports.getTheme = getTheme;
exports.getTimeHistory = getTimeHistory;
exports.getTimefilter = getTimefilter;
exports.getToastNotifications = getToastNotifications;
exports.getUiSettings = getUiSettings;
exports.setDependencyCache = setDependencyCache;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cache = {
  timefilter: null,
  config: null,
  chrome: null,
  docLinks: null,
  toastNotifications: null,
  overlays: null,
  theme: null,
  recentlyAccessed: null,
  fieldFormats: null,
  autocomplete: null,
  basePath: null,
  savedSearch: null,
  application: null,
  http: null,
  security: null,
  i18n: null,
  dashboard: null,
  maps: null,
  dataVisualizer: null,
  dataViews: null,
  share: null,
  lens: null
};
function setDependencyCache(deps) {
  cache.timefilter = deps.timefilter || null;
  cache.config = deps.config || null;
  cache.chrome = deps.chrome || null;
  cache.docLinks = deps.docLinks || null;
  cache.toastNotifications = deps.toastNotifications || null;
  cache.overlays = deps.overlays || null;
  cache.theme = deps.theme || null;
  cache.recentlyAccessed = deps.recentlyAccessed || null;
  cache.fieldFormats = deps.fieldFormats || null;
  cache.autocomplete = deps.autocomplete || null;
  cache.basePath = deps.basePath || null;
  cache.savedSearch = deps.savedSearch || null;
  cache.application = deps.application || null;
  cache.http = deps.http || null;
  cache.security = deps.security || null;
  cache.i18n = deps.i18n || null;
  cache.dashboard = deps.dashboard || null;
  cache.dataVisualizer = deps.dataVisualizer || null;
  cache.dataViews = deps.dataViews || null;
  cache.share = deps.share || null;
  cache.lens = deps.lens || null;
}
function getTimefilter() {
  if (cache.timefilter === null) {
    throw new Error("timefilter hasn't been initialized");
  }
  return cache.timefilter.timefilter;
}
function getTimeHistory() {
  if (cache.timefilter === null) {
    throw new Error("timefilter hasn't been initialized");
  }
  return cache.timefilter.history;
}
function getDocLinks() {
  if (cache.docLinks === null) {
    throw new Error("docLinks hasn't been initialized");
  }
  return cache.docLinks;
}
function getToastNotifications() {
  if (cache.toastNotifications === null) {
    throw new Error("toast notifications haven't been initialized");
  }
  return cache.toastNotifications;
}
function getOverlays() {
  if (cache.overlays === null) {
    throw new Error("overlays haven't been initialized");
  }
  return cache.overlays;
}
function getTheme() {
  if (cache.theme === null) {
    throw new Error("theme hasn't been initialized");
  }
  return cache.theme;
}
function getUiSettings() {
  if (cache.config === null) {
    throw new Error("uiSettings hasn't been initialized");
  }
  return cache.config;
}
function getRecentlyAccessed() {
  if (cache.recentlyAccessed === null) {
    throw new Error("recentlyAccessed hasn't been initialized");
  }
  return cache.recentlyAccessed;
}
function getFieldFormats() {
  if (cache.fieldFormats === null) {
    throw new Error("fieldFormats hasn't been initialized");
  }
  return cache.fieldFormats;
}
function getAutocomplete() {
  if (cache.autocomplete === null) {
    throw new Error("autocomplete hasn't been initialized");
  }
  return cache.autocomplete;
}
function getChrome() {
  if (cache.chrome === null) {
    throw new Error("chrome hasn't been initialized");
  }
  return cache.chrome;
}
function getBasePath() {
  if (cache.basePath === null) {
    throw new Error("basePath hasn't been initialized");
  }
  return cache.basePath;
}
function getApplication() {
  if (cache.application === null) {
    throw new Error("application hasn't been initialized");
  }
  return cache.application;
}
function getHttp() {
  if (cache.http === null) {
    throw new Error("http hasn't been initialized");
  }
  return cache.http;
}
function getSecurity() {
  if (cache.security === null) {
    throw new Error("security hasn't been initialized");
  }
  return cache.security;
}
function getI18n() {
  if (cache.i18n === null) {
    throw new Error("i18n hasn't been initialized");
  }
  return cache.i18n;
}
function getDashboard() {
  if (cache.dashboard === null) {
    throw new Error("dashboard hasn't been initialized");
  }
  return cache.dashboard;
}
function getDataViews() {
  if (cache.dataViews === null) {
    throw new Error("dataViews hasn't been initialized");
  }
  return cache.dataViews;
}
function getFileDataVisualizer() {
  if (cache.dataVisualizer === null) {
    throw new Error("dataVisualizer hasn't been initialized");
  }
  return cache.dataVisualizer;
}
function getShare() {
  if (cache.share === null) {
    throw new Error("share hasn't been initialized");
  }
  return cache.share;
}
function getLens() {
  if (cache.lens === null) {
    throw new Error("lens hasn't been initialized");
  }
  return cache.lens;
}
function clearCache() {
  Object.keys(cache).forEach(k => {
    cache[k] = null;
  });
}