"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterListsUI = exports.FilterLists = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = require("prop-types");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _header = require("./header");
var _table = require("./table");
var _ml_api_service = require("../../../services/ml_api_service");
var _dependency_cache = require("../../../util/dependency_cache");
var _help_menu = require("../../../components/help_menu");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React table for displaying a table of filter lists.
 */

class FilterListsUI extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "setFilterLists", filterLists => {
      // Check selected filter lists still exist.
      this.setState(prevState => {
        const loadedFilterIds = filterLists.map(filterList => filterList.filter_id);
        const selectedFilterLists = prevState.selectedFilterLists.filter(filterList => {
          return loadedFilterIds.indexOf(filterList.filter_id) !== -1;
        });
        return {
          filterLists,
          selectedFilterLists
        };
      });
    });
    (0, _defineProperty2.default)(this, "setSelectedFilterLists", selectedFilterLists => {
      this.setState({
        selectedFilterLists
      });
    });
    (0, _defineProperty2.default)(this, "refreshFilterLists", () => {
      // Load the list of filters.
      _ml_api_service.ml.filters.filtersStats().then(filterLists => {
        this.setFilterLists(filterLists);
      }).catch(resp => {
        console.log('Error loading list of filters:', resp);
        const {
          toasts
        } = this.props.kibana.services.notifications;
        toasts.addDanger(_i18n.i18n.translate('xpack.ml.settings.filterLists.filterLists.loadingFilterListsErrorMessage', {
          defaultMessage: 'An error occurred loading the filter lists'
        }));
      });
    });
    this.state = {
      filterLists: [],
      selectedFilterLists: []
    };
  }
  componentDidMount() {
    this.refreshFilterLists();
  }
  render() {
    const {
      filterLists,
      selectedFilterLists
    } = this.state;
    const {
      canCreateFilter,
      canDeleteFilter
    } = this.props;
    const helpLink = (0, _dependency_cache.getDocLinks)().links.ml.customRules;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "mlPageFilterListManagement"
    }, /*#__PURE__*/_react.default.createElement(_header.FilterListsHeader, {
      totalCount: filterLists.length,
      refreshFilterLists: this.refreshFilterLists
    }), /*#__PURE__*/_react.default.createElement(_table.FilterListsTable, {
      canCreateFilter: canCreateFilter,
      canDeleteFilter: canDeleteFilter,
      filterLists: filterLists,
      selectedFilterLists: selectedFilterLists,
      setSelectedFilterLists: this.setSelectedFilterLists,
      refreshFilterLists: this.refreshFilterLists
    })), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
      docLink: helpLink
    }));
  }
}
exports.FilterListsUI = FilterListsUI;
(0, _defineProperty2.default)(FilterListsUI, "displayName", 'FilterLists');
(0, _defineProperty2.default)(FilterListsUI, "propTypes", {
  canCreateFilter: _propTypes.PropTypes.bool.isRequired,
  canDeleteFilter: _propTypes.PropTypes.bool.isRequired
});
const FilterLists = (0, _public.withKibana)(FilterListsUI);
exports.FilterLists = FilterLists;