"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CalendarForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = require("prop-types");
var _eui = require("@elastic/eui");
var _events_table = require("../events_table");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _locator = require("../../../../../../common/constants/locator");
var _use_create_url = require("../../../../contexts/kibana/use_create_url");
var _page_header = require("../../../../components/page_header");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EditHeader({
  calendarId,
  description
}) {
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": 'mlCalendarTitle'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.calendarsEdit.calendarForm.calendarTitle",
    defaultMessage: "Calendar {calendarId}",
    values: {
      calendarId
    }
  }))), description ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": 'mlCalendarDescriptionText'
  }, /*#__PURE__*/_react.default.createElement("p", null, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })) : null);
}
const CalendarForm = ({
  calendarId,
  canCreateCalendar,
  canDeleteCalendar,
  description,
  eventsList,
  groupIds,
  isEdit,
  isNewCalendarIdValid,
  jobIds,
  onCalendarIdChange,
  onCreate,
  onCreateGroupOption,
  onDescriptionChange,
  onEdit,
  onEventDelete,
  onGroupSelection,
  showImportModal,
  onJobSelection,
  saving,
  loading,
  selectedGroupOptions,
  selectedJobOptions,
  showNewEventModal,
  isGlobalCalendar,
  onGlobalCalendarChange
}) => {
  const msg = _i18n.i18n.translate('xpack.ml.calendarsEdit.calendarForm.allowedCharactersDescription', {
    defaultMessage: 'Use lowercase alphanumerics (a-z and 0-9), hyphens or underscores; ' + 'must start and end with an alphanumeric character'
  });
  const helpText = isNewCalendarIdValid === true && !isEdit ? msg : undefined;
  const error = isNewCalendarIdValid === false && !isEdit ? [msg] : undefined;
  const saveButtonDisabled = canCreateCalendar === false || saving || !isNewCalendarIdValid || calendarId === '' || loading === true;
  const redirectToCalendarsManagementPage = (0, _use_create_url.useCreateAndNavigateToMlLink)(_locator.ML_PAGES.CALENDARS_MANAGE);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": `mlCalendarForm${isEdit === true ? 'Edit' : 'New'}`
  }, isEdit === true ? /*#__PURE__*/_react.default.createElement(EditHeader, {
    calendarId: calendarId,
    description: description
  }) : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.calendarsEdit.calendarForm.createCalendarTitle",
    defaultMessage: "Create new calendar"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.calendarForm.calendarIdLabel",
      defaultMessage: "Calendar ID"
    }),
    helpText: helpText,
    error: error,
    isInvalid: !isNewCalendarIdValid
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "calendarId",
    value: calendarId,
    onChange: onCalendarIdChange,
    disabled: isEdit === true || saving === true || loading === true,
    "data-test-subj": "mlCalendarIdInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.calendarForm.descriptionLabel",
      defaultMessage: "Description"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "description",
    value: description,
    onChange: onDescriptionChange,
    disabled: isEdit === true || saving === true || loading === true,
    "data-test-subj": "mlCalendarDescriptionInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "switch",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.calendarForm.allJobsLabel",
      defaultMessage: "Apply calendar to all jobs"
    }),
    checked: isGlobalCalendar,
    onChange: onGlobalCalendarChange,
    disabled: saving === true || canCreateCalendar === false || loading === true,
    "data-test-subj": "mlCalendarApplyToAllJobsSwitch"
  }), isGlobalCalendar === false && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.calendarForm.jobsLabel",
      defaultMessage: "Jobs"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: jobIds,
    selectedOptions: selectedJobOptions,
    onChange: onJobSelection,
    isDisabled: saving === true || canCreateCalendar === false || loading === true,
    "data-test-subj": "mlCalendarJobSelection"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.calendarForm.groupsLabel",
      defaultMessage: "Groups"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    onCreateOption: onCreateGroupOption,
    options: groupIds,
    selectedOptions: selectedGroupOptions,
    onChange: onGroupSelection,
    isDisabled: saving === true || canCreateCalendar === false || loading === true,
    "data-test-subj": "mlCalendarJobGroupSelection"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.calendarForm.eventsLabel",
      defaultMessage: "Events"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_events_table.EventsTable, {
    canCreateCalendar: canCreateCalendar,
    canDeleteCalendar: canDeleteCalendar,
    eventsList: eventsList,
    onDeleteClick: onEventDelete,
    showImportModal: showImportModal,
    showNewEventModal: showNewEventModal,
    loading: loading,
    saving: saving,
    showSearchBar: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: saving,
    onClick: redirectToCalendarsManagementPage
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.calendarsEdit.calendarForm.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlSaveCalendarButton",
    fill: true,
    onClick: isEdit ? onEdit : onCreate,
    isDisabled: saveButtonDisabled
  }, saving ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.calendarsEdit.calendarForm.savingButtonLabel",
    defaultMessage: "Saving\u2026"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.calendarsEdit.calendarForm.saveButtonLabel",
    defaultMessage: "Save"
  })))));
};
exports.CalendarForm = CalendarForm;
CalendarForm.propTypes = {
  calendarId: _propTypes.PropTypes.string.isRequired,
  canCreateCalendar: _propTypes.PropTypes.bool.isRequired,
  canDeleteCalendar: _propTypes.PropTypes.bool.isRequired,
  description: _propTypes.PropTypes.string,
  groupIds: _propTypes.PropTypes.array.isRequired,
  isEdit: _propTypes.PropTypes.bool.isRequired,
  isNewCalendarIdValid: _propTypes.PropTypes.bool.isRequired,
  jobIds: _propTypes.PropTypes.array.isRequired,
  onCalendarIdChange: _propTypes.PropTypes.func.isRequired,
  onCreate: _propTypes.PropTypes.func.isRequired,
  onCreateGroupOption: _propTypes.PropTypes.func.isRequired,
  onDescriptionChange: _propTypes.PropTypes.func.isRequired,
  onEdit: _propTypes.PropTypes.func.isRequired,
  onEventDelete: _propTypes.PropTypes.func.isRequired,
  onGroupSelection: _propTypes.PropTypes.func.isRequired,
  showImportModal: _propTypes.PropTypes.func.isRequired,
  onJobSelection: _propTypes.PropTypes.func.isRequired,
  saving: _propTypes.PropTypes.bool.isRequired,
  loading: _propTypes.PropTypes.bool.isRequired,
  selectedGroupOptions: _propTypes.PropTypes.array.isRequired,
  selectedJobOptions: _propTypes.PropTypes.array.isRequired,
  showNewEventModal: _propTypes.PropTypes.func.isRequired,
  isGlobalCalendar: _propTypes.PropTypes.bool.isRequired,
  onGlobalCalendarChange: _propTypes.PropTypes.func.isRequired
};