"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSeriesConfigWithMetadata = exports.DEFAULT_MAX_SERIES_TO_PLOT = exports.AnomalyExplorerChartsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _swimlane_container = require("../explorer/swimlane_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_CHARTS_PER_ROW = 4;
const OPTIMAL_CHART_WIDTH = 550;
const isSeriesConfigWithMetadata = arg => {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['bucketSpanSeconds', 'detectorLabel']);
};
exports.isSeriesConfigWithMetadata = isSeriesConfigWithMetadata;
const DEFAULT_MAX_SERIES_TO_PLOT = 6;

/**
 * Service for retrieving anomaly explorer charts data.
 */
exports.DEFAULT_MAX_SERIES_TO_PLOT = DEFAULT_MAX_SERIES_TO_PLOT;
class AnomalyExplorerChartsService {
  constructor(timeFilter, mlApiServices, mlResultsService) {
    (0, _defineProperty2.default)(this, "_customTimeRange", void 0);
    this.timeFilter = timeFilter;
    this.mlApiServices = mlApiServices;
    this.mlResultsService = mlResultsService;
    this.timeFilter.enableTimeRangeSelector();
  }
  setTimeRange(timeRange) {
    this._customTimeRange = timeRange;
  }
  getTimeBounds() {
    return this._customTimeRange !== undefined ? this.timeFilter.calculateBounds(this._customTimeRange) : this.timeFilter.getBounds();
  }
  async getCombinedJobs(jobIds) {
    const combinedResults = await Promise.all(
    // Getting only necessary job config and datafeed config without the stats
    jobIds.map(jobId => this.mlApiServices.jobs.jobForCloning(jobId)));
    return combinedResults.filter(_mlIsDefined.isDefined).filter(r => r.job !== undefined && r.datafeed !== undefined).map(({
      job,
      datafeed
    }) => ({
      ...job,
      datafeed_config: datafeed
    }));
  }
  loadDataForCharts$(jobIds, earliestMs, latestMs, influencers = [], selectedCells, influencersFilterQuery) {
    if (!selectedCells && influencers.length === 0 && influencersFilterQuery === undefined) {
      (0, _rxjs.of)([]);
    }
    return this.mlResultsService.getRecordsForInfluencer$(jobIds, influencers, 0, earliestMs, latestMs, 500, influencersFilterQuery).pipe((0, _operators.map)(resp => {
      if ((0, _mlIsPopulatedObject.isPopulatedObject)(selectedCells) || influencersFilterQuery !== undefined) {
        return resp.records;
      }
      return [];
    }));
  }
  getAnomalyData$(jobIds, chartsContainerWidth, selectedEarliestMs, selectedLatestMs, influencerFilterQuery, influencers, severity = 0, maxSeries) {
    const bounds = this.getTimeBounds();
    const boundsMin = bounds !== null && bounds !== void 0 && bounds.min ? bounds.min.valueOf() : undefined;
    const boundsMax = bounds !== null && bounds !== void 0 && bounds.max ? bounds.max.valueOf() : undefined;
    const containerWidth = chartsContainerWidth + _swimlane_container.SWIM_LANE_LABEL_WIDTH;

    // Calculate the number of charts per row, depending on the width available, to a max of 4.
    let chartsPerRow = Math.min(Math.max(Math.floor(containerWidth / OPTIMAL_CHART_WIDTH), 1), MAX_CHARTS_PER_ROW);

    // Expand the charts to not have blank space in the row if necessary
    if (maxSeries && maxSeries < chartsPerRow) {
      chartsPerRow = maxSeries;
    }
    const chartWidth = Math.floor(containerWidth / chartsPerRow);
    const optimumPointSpacing = 5;
    const optimumNumPoints = Math.ceil(chartWidth / optimumPointSpacing);
    const maxSeriesToPlot = maxSeries !== null && maxSeries !== void 0 ? maxSeries : Math.max(chartsPerRow * 2, DEFAULT_MAX_SERIES_TO_PLOT);
    return this.mlApiServices.results.getAnomalyCharts$(jobIds, influencers !== null && influencers !== void 0 ? influencers : [], severity, selectedEarliestMs, selectedLatestMs, {
      min: boundsMin,
      max: boundsMax
    }, maxSeriesToPlot, optimumNumPoints, influencerFilterQuery).pipe((0, _operators.map)(data => {
      chartsPerRow = Math.min(data.seriesToPlot.length, chartsPerRow);
      data.chartsPerRow = chartsPerRow;
      return data;
    }));
  }
}
exports.AnomalyExplorerChartsService = AnomalyExplorerChartsService;