"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRefresh = void 0;
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _react = require("react");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _annotations_service = require("../services/annotations_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook that provides the latest refresh timestamp
 * and the most recent applied time range.
 */
const useRefresh = () => {
  const timefilter = (0, _mlDatePicker.useTimefilter)();
  const getTimeRange = () => {
    const {
      from,
      to
    } = timefilter.getTime();
    return {
      start: from,
      end: to
    };
  };
  const refresh$ = (0, _react.useMemo)(() => {
    return (0, _rxjs.merge)(_mlDatePicker.mlTimefilterRefresh$, timefilter.getTimeUpdate$().pipe((0, _operators.map)(() => {
      return {
        lastRefresh: Date.now(),
        timeRange: getTimeRange()
      };
    })), _annotations_service.annotationsRefresh$.pipe((0, _operators.map)(d => ({
      lastRefresh: d
    }))));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return (0, _useObservable.default)(refresh$);
};
exports.useRefresh = useRefresh;