"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestDfaModelsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _test_pipeline = require("../components/ml_inference/components/test_pipeline");
var _state = require("../components/ml_inference/state");
var _types = require("../components/ml_inference/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TestDfaModelsFlyout = ({
  model,
  onClose
}) => {
  const sourceIndex = (0, _react.useMemo)(() => {
    var _model$metadata, _model$metadata2, _model$metadata3;
    return Array.isArray((_model$metadata = model.metadata) === null || _model$metadata === void 0 ? void 0 : _model$metadata.analytics_config.source.index) ? (_model$metadata2 = model.metadata) === null || _model$metadata2 === void 0 ? void 0 : _model$metadata2.analytics_config.source.index.join() : (_model$metadata3 = model.metadata) === null || _model$metadata3 === void 0 ? void 0 : _model$metadata3.analytics_config.source.index;
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [model === null || model === void 0 ? void 0 : model.model_id]);
  const state = (0, _react.useMemo)(() => (0, _state.getInitialState)(model),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [model === null || model === void 0 ? void 0 : model.model_id]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "l",
    onClose: onClose,
    "data-test-subj": "mlTestModelsFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.testDfaModelsFlyout.headerLabel",
    defaultMessage: "Test trained model"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, model.model_id))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_test_pipeline.TestPipeline, {
    state: state,
    sourceIndex: sourceIndex,
    mode: _types.TEST_PIPELINE_MODE.STAND_ALONE
  })));
};
exports.TestDfaModelsFlyout = TestDfaModelsFlyout;