"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobSettingsForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _data_source_context = require("../../../../contexts/ml/data_source_context");
var _page = require("../page");
var _validators = require("../../../../../../common/util/validators");
var _validation = require("../../../../../../common/constants/validation");
var _components = require("../../common/components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobSettingsForm = ({
  onSubmit,
  onJobPrefixChange,
  saveState,
  jobs
}) => {
  const timefilter = (0, _mlDatePicker.useTimefilter)();
  const {
    from,
    to
  } = (0, _mlDatePicker.getTimeFilterRange)(timefilter);
  const {
    selectedDataView: dataView
  } = (0, _data_source_context.useDataSource)();
  const jobPrefixValidator = (0, _react.useMemo)(() => (0, _validators.composeValidators)((0, _validators.patternValidator)(/^([a-z0-9]+[a-z0-9\-_]*)?$/), (0, _validators.maxLengthValidator)(_validation.JOB_ID_MAX_LENGTH - Math.max(...jobs.map(({
    id
  }) => id.length)))), [jobs]);
  const [jobPrefix, setJobPrefix] = (0, _react.useState)('');
  const [startDatafeedAfterSave, setStartDatafeedAfterSave] = (0, _react.useState)(true);
  const [useFullIndexData, setUseFullIndexData] = (0, _react.useState)(true);
  const [timeRange, setTimeRange] = (0, _react.useState)({
    start: from,
    end: to
  });
  const [useDedicatedIndex, setUseDedicatedIndex] = (0, _react.useState)(false);
  const [validationResult, setValidationResult] = (0, _react.useState)({});
  const createJobSettings = () => {
    return {
      jobPrefix,
      startDatafeedAfterSave,
      useFullIndexData,
      timeRange,
      useDedicatedIndex
    };
  };
  const handleValidation = (0, _react.useCallback)(() => {
    const jobPrefixValidationResult = jobPrefixValidator(jobPrefix);
    setValidationResult({
      jobPrefix: jobPrefixValidationResult,
      formValid: !jobPrefixValidationResult
    });
  }, [jobPrefix, jobPrefixValidator]);
  (0, _react.useEffect)(() => {
    handleValidation();
    onJobPrefixChange(jobPrefix);
  }, [handleValidation, jobPrefix, onJobPrefixChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.jobIdPrefixLabel",
      defaultMessage: "Job ID prefix"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.tooltips.newJobRecognizerJobPrefixTooltip",
      defaultMessage: "The prefix is added to the beginning of each job ID."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.jobIdPrefixLabel",
      defaultMessage: "Job ID prefix"
    }),
    isInvalid: !!validationResult.jobPrefix,
    error: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, validationResult.jobPrefix && validationResult.jobPrefix.maxLength ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.jobPrefixInvalidMaxLengthErrorMessage",
      defaultMessage: "Job ID prefix must be no more than {maxLength, plural, one {# character} other {# characters}} long.",
      values: {
        maxLength: validationResult.jobPrefix.maxLength.requiredLength
      }
    })) : null, validationResult.jobPrefix && validationResult.jobPrefix.pattern && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.jobLabelAllowedCharactersDescription",
      defaultMessage: "Job label can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with an alphanumeric character"
    })))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "jobPrefix",
    value: jobPrefix,
    onChange: ({
      target: {
        value
      }
    }) => setJobPrefix(value),
    isInvalid: !!validationResult.jobPrefix,
    "data-test-subj": "mlJobRecognizerWizardInputJobIdPrefix"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "startDataFeed",
    name: "startDataFeed",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.startDatafeedAfterSaveLabel",
      defaultMessage: "Start datafeed after save"
    }),
    checked: startDatafeedAfterSave,
    onChange: ({
      target: {
        checked
      }
    }) => {
      setStartDatafeedAfterSave(checked);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "useFullData",
    name: "useFullData",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.useFullDataLabel",
      defaultMessage: "Use full {dataViewIndexPattern} data",
      values: {
        dataViewIndexPattern: dataView.getIndexPattern()
      }
    }),
    checked: useFullIndexData,
    onChange: ({
      target: {
        checked
      }
    }) => {
      setUseFullIndexData(checked);
    }
  })), !useFullIndexData && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_components.TimeRangePicker, {
    setTimeRange: setTimeRange,
    timeRange: timeRange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "advancedOptions",
    "aria-label": _i18n.i18n.translate('xpack.ml.newJob.recognize.advancedSettingsAriaLabel', {
      defaultMessage: 'Advanced settings'
    }),
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.advancedLabel",
      defaultMessage: "Advanced"
    }),
    paddingSize: "l",
    "data-test-subj": "mlJobWizardToggleAdvancedSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.recognize.useDedicatedIndexLabel",
      defaultMessage: "Use dedicated index"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.tooltips.newJobDedicatedIndexTooltip",
      defaultMessage: "Store results in a separate index for this job."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    describedByIds: ['ml_aria_label_new_job_dedicated_index'],
    "data-test-subj": "mlJobWizardAdvancedSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "useDedicatedIndex",
    name: "useDedicatedIndex",
    checked: useDedicatedIndex,
    onChange: ({
      target: {
        checked
      }
    }) => {
      setUseDedicatedIndex(checked);
    },
    label: _i18n.i18n.translate('xpack.ml.newJob.recognize.useDedicatedIndexLabel', {
      defaultMessage: 'Use dedicated index'
    })
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "right"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    isLoading: saveState === _page.SAVE_STATE.SAVING,
    disabled: !validationResult.formValid || saveState === _page.SAVE_STATE.SAVING,
    onClick: () => {
      onSubmit(createJobSettings());
    },
    "aria-label": _i18n.i18n.translate('xpack.ml.newJob.recognize.createJobButtonAriaLabel', {
      defaultMessage: 'Create job'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.recognize.createJobButtonLabel",
    defaultMessage: "Create {numberOfJobs, plural, zero {job} one {job} other {jobs}}",
    values: {
      numberOfJobs: jobs.length
    }
  }))));
};
exports.JobSettingsForm = JobSettingsForm;