"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.preConfiguredJobRedirect = preConfiguredJobRedirect;
var _job_service = require("../../../../services/job_service");
var _new_job = require("../../../../../../common/constants/new_job");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function preConfiguredJobRedirect(dataViewsService, basePath, navigateToUrl) {
  const {
    createdBy,
    job,
    datafeed
  } = _job_service.mlJobService.tempJobCloningObjects;
  if (job && datafeed) {
    const dataViewId = await getDataViewIdFromDatafeed(job, datafeed, dataViewsService);
    if (dataViewId === null) {
      return Promise.resolve();
    }
    try {
      const redirectUrl = await getWizardUrlFromCloningJob(createdBy, dataViewId);
      await navigateToUrl(`${basePath}/app/ml/${redirectUrl}`);
      return Promise.reject();
    } catch (error) {
      return Promise.resolve();
    }
  } else {
    // no job to clone
    // don't redirect
    return Promise.resolve();
  }
}
async function getWizardUrlFromCloningJob(createdBy, dataViewId) {
  const created = createdBy;
  let page = '';
  switch (created) {
    case _new_job.CREATED_BY_LABEL.SINGLE_METRIC:
    case _new_job.CREATED_BY_LABEL.SINGLE_METRIC_FROM_LENS:
      page = _new_job.JOB_TYPE.SINGLE_METRIC;
      break;
    case _new_job.CREATED_BY_LABEL.MULTI_METRIC:
    case _new_job.CREATED_BY_LABEL.MULTI_METRIC_FROM_LENS:
      page = _new_job.JOB_TYPE.MULTI_METRIC;
      break;
    case _new_job.CREATED_BY_LABEL.POPULATION:
      page = _new_job.JOB_TYPE.POPULATION;
      break;
    case _new_job.CREATED_BY_LABEL.CATEGORIZATION:
    case _new_job.CREATED_BY_LABEL.CATEGORIZATION_FROM_PATTERN_ANALYSIS:
      page = _new_job.JOB_TYPE.CATEGORIZATION;
      break;
    case _new_job.CREATED_BY_LABEL.RARE:
      page = _new_job.JOB_TYPE.RARE;
      break;
    case _new_job.CREATED_BY_LABEL.GEO:
      page = _new_job.JOB_TYPE.GEO;
      break;
    case _new_job.CREATED_BY_LABEL.ADVANCED:
    default:
      page = _new_job.JOB_TYPE.ADVANCED;
      break;
  }
  return `jobs/new_job/${page}?index=${dataViewId}&_g=()`;
}
async function getDataViewIdFromDatafeed(job, datafeed, dataViewsService) {
  var _dataView$id;
  if (dataViewsService === null) {
    throw new Error('Data views are not initialized!');
  }
  const indexPattern = datafeed.indices.join(',');
  const dataViews = await (dataViewsService === null || dataViewsService === void 0 ? void 0 : dataViewsService.find(indexPattern));
  const dataView = dataViews.find(dv => dv.getIndexPattern() === indexPattern);
  if (dataView === undefined) {
    var _tempDataView$id;
    // create a temporary data view if we can't find one
    // matching the index pattern
    const tempDataView = await dataViewsService.create({
      id: undefined,
      name: indexPattern,
      title: indexPattern,
      timeFieldName: job.data_description.time_field
    });
    return (_tempDataView$id = tempDataView.id) !== null && _tempDataView$id !== void 0 ? _tempDataView$id : null;
  }
  return (_dataView$id = dataView.id) !== null && _dataView$id !== void 0 ? _dataView$id : null;
}