"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryCountField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _summary_count_field_select = require("./summary_count_field_select");
var _job_creator_context = require("../../../job_creator_context");
var _new_job_capabilities_service = require("../../../../../../../services/new_job_capabilities/new_job_capabilities_service");
var _description = require("./description");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SummaryCountField = () => {
  const {
    jobCreator: jc,
    jobCreatorUpdate,
    jobCreatorUpdated,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const {
    fields
  } = _new_job_capabilities_service.newJobCapsService;
  const [summaryCountFieldName, setSummaryCountFieldName] = (0, _react.useState)(jobCreator.summaryCountFieldName);
  const [validation, setValidation] = (0, _react.useState)(jobValidator.summaryCountField);
  (0, _react.useEffect)(() => {
    setValidation(jobValidator.summaryCountField);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  (0, _react.useEffect)(() => {
    jobCreator.summaryCountFieldName = summaryCountFieldName;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [summaryCountFieldName]);
  (0, _react.useEffect)(() => {
    setSummaryCountFieldName(jobCreator.summaryCountFieldName);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_description.Description, {
    validation: validation
  }, /*#__PURE__*/_react.default.createElement(_summary_count_field_select.SummaryCountFieldSelect, {
    fields: fields,
    changeHandler: setSummaryCountFieldName,
    selectedField: summaryCountFieldName
  }));
};
exports.SummaryCountField = SummaryCountField;