"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MMLCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../../job_creator_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MMLCallout = () => {
  const {
    jobCreator,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [highCardinality, setHighCardinality] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    var _jobValidator$latestV, _jobValidator$latestV2, _jobValidator$latestV3;
    const value = (_jobValidator$latestV = (_jobValidator$latestV2 = jobValidator.latestValidationResult) === null || _jobValidator$latestV2 === void 0 ? void 0 : (_jobValidator$latestV3 = _jobValidator$latestV2.highCardinality) === null || _jobValidator$latestV3 === void 0 ? void 0 : _jobValidator$latestV3.value) !== null && _jobValidator$latestV !== void 0 ? _jobValidator$latestV : null;
    setHighCardinality(value);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  return jobCreator.modelPlot && highCardinality !== null ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.jobDetailsStep.advancedSection.mmlWarning.title",
      defaultMessage: "Proceed with caution!"
    }),
    color: "warning",
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jobDetailsStep.advancedSection.mmlWarning.message",
    defaultMessage: "Creating model plots is resource intensive and not recommended where the cardinality of the selected fields is greater than 100. Estimated cardinality for this job is {highCardinality}. If you enable model plot with this configuration we recommend you use a dedicated results index.",
    values: {
      highCardinality
    }
  }))) : null;
};
exports.MMLCallout = MMLCallout;