"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobsListView = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ml_api_service = require("../../../../services/ml_api_service");
var _utils = require("../utils");
var _jobs_list = require("../jobs_list");
var _job_details = require("../job_details");
var _job_filter_bar = require("../job_filter_bar");
var _edit_job_flyout = require("../edit_job_flyout");
var _datafeed_chart_flyout = require("../datafeed_chart_flyout");
var _delete_job_modal = require("../delete_job_modal");
var _reset_job_modal = require("../reset_job_modal");
var _start_datafeed_modal = require("../start_datafeed_modal");
var _multi_job_actions = require("../multi_job_actions");
var _new_job_button = require("../new_job_button");
var _jobs_stats_bar = require("../jobs_stats_bar");
var _node_available_warning = require("../../../../components/node_available_warning");
var _jobs_awaiting_node_warning = require("../../../../components/jobs_awaiting_node_warning");
var _saved_objects_warning = require("../../../../components/saved_objects_warning");
var _upgrade = require("../../../../components/upgrade");
var _jobs_list2 = require("../../../../../../common/constants/jobs_list");
var _ml_alerting_flyout = require("../../../../../alerting/ml_alerting_flyout");
var _stop_datafeeds_confirm_modal = require("../confirm_modals/stop_datafeeds_confirm_modal");
var _close_jobs_confirm_modal = require("../confirm_modals/close_jobs_confirm_modal");
var _anomaly_detection_empty_state = require("../anomaly_detection_empty_state");
var _job_utils = require("../../../../../../common/util/job_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let blockingJobsRefreshTimeout = null;
class JobsListView extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "toggleRow", jobId => {
      if (this.state.itemIdToExpandedRowMap[jobId]) {
        const itemIdToExpandedRowMap = {
          ...this.state.itemIdToExpandedRowMap
        };
        delete itemIdToExpandedRowMap[jobId];
        this.setState({
          itemIdToExpandedRowMap
        });
      } else {
        // Only show clear notifications button if job has warning icon due to auditMessage
        const expandedJob = this.state.jobsSummaryList.filter(job => job.id === jobId);
        const showClearButton = expandedJob.length > 0 && expandedJob[0].auditMessage !== undefined;
        let itemIdToExpandedRowMap = {
          ...this.state.itemIdToExpandedRowMap
        };
        if (this.state.fullJobsList[jobId] !== undefined) {
          itemIdToExpandedRowMap[jobId] = /*#__PURE__*/_react.default.createElement(_job_details.JobDetails, {
            jobId: jobId,
            job: this.state.fullJobsList[jobId],
            addYourself: this.addUpdateFunction,
            removeYourself: this.removeUpdateFunction,
            refreshJobList: this.onRefreshClick,
            showClearButton: showClearButton
          });
        } else {
          itemIdToExpandedRowMap[jobId] = /*#__PURE__*/_react.default.createElement(_job_details.JobDetails, {
            jobId: jobId,
            addYourself: this.addUpdateFunction,
            removeYourself: this.removeUpdateFunction,
            refreshJobList: this.onRefreshClick,
            showClearButton: showClearButton
          });
        }
        this.setState({
          itemIdToExpandedRowMap
        }, () => {
          (0, _utils.loadFullJob)(jobId).then(job => {
            const fullJobsList = {
              ...this.state.fullJobsList
            };
            if (this.props.showNodeInfo === false) {
              job = (0, _job_utils.removeNodeInfo)(job);
            }
            fullJobsList[jobId] = job;
            this.setState({
              fullJobsList
            }, () => {
              // take a fresh copy of the itemIdToExpandedRowMap object
              itemIdToExpandedRowMap = {
                ...this.state.itemIdToExpandedRowMap
              };
              if (itemIdToExpandedRowMap[jobId] !== undefined) {
                // wrap in a check, in case the user closes the expansion before the
                // loading has finished
                itemIdToExpandedRowMap[jobId] = /*#__PURE__*/_react.default.createElement(_job_details.JobDetails, {
                  jobId: jobId,
                  job: job,
                  addYourself: this.addUpdateFunction,
                  removeYourself: this.removeUpdateFunction,
                  refreshJobList: this.onRefreshClick,
                  showClearButton: showClearButton
                });
              }
              this.setState({
                itemIdToExpandedRowMap
              }, () => {
                this.updateFunctions[jobId](job);
              });
            });
          }).catch(error => {
            console.error(error);
          });
        });
      }
    });
    (0, _defineProperty2.default)(this, "addUpdateFunction", (id, f) => {
      this.updateFunctions[id] = f;
    });
    (0, _defineProperty2.default)(this, "removeUpdateFunction", id => {
      delete this.updateFunctions[id];
    });
    (0, _defineProperty2.default)(this, "setShowEditJobFlyoutFunction", func => {
      this.showEditJobFlyout = func;
    });
    (0, _defineProperty2.default)(this, "unsetShowEditJobFlyoutFunction", () => {
      this.showEditJobFlyout = () => {};
    });
    (0, _defineProperty2.default)(this, "setShowDatafeedChartFlyoutFunction", func => {
      this.showDatafeedChartFlyout = func;
    });
    (0, _defineProperty2.default)(this, "unsetShowDatafeedChartFlyoutFunction", () => {
      this.showDatafeedChartFlyout = () => {};
    });
    (0, _defineProperty2.default)(this, "setShowStopDatafeedsConfirmModalFunction", func => {
      this.showStopDatafeedsConfirmModal = func;
    });
    (0, _defineProperty2.default)(this, "unsetShowStopDatafeedsConfirmModalFunction", () => {
      this.showStopDatafeedsConfirmModal = () => {};
    });
    (0, _defineProperty2.default)(this, "setShowCloseJobsConfirmModalFunction", func => {
      this.showCloseJobsConfirmModal = func;
    });
    (0, _defineProperty2.default)(this, "unsetShowCloseJobsConfirmModalFunction", () => {
      this.showCloseJobsConfirmModal = () => {};
    });
    (0, _defineProperty2.default)(this, "setShowDeleteJobModalFunction", func => {
      this.showDeleteJobModal = func;
    });
    (0, _defineProperty2.default)(this, "unsetShowDeleteJobModalFunction", () => {
      this.showDeleteJobModal = () => {};
    });
    (0, _defineProperty2.default)(this, "setShowResetJobModalFunction", func => {
      this.showResetJobModal = func;
    });
    (0, _defineProperty2.default)(this, "unsetShowResetJobModalFunction", () => {
      this.showResetJobModal = () => {};
    });
    (0, _defineProperty2.default)(this, "setShowStartDatafeedModalFunction", func => {
      this.showStartDatafeedModal = func;
    });
    (0, _defineProperty2.default)(this, "unsetShowStartDatafeedModalFunction", () => {
      this.showStartDatafeedModal = () => {};
    });
    (0, _defineProperty2.default)(this, "setShowCreateAlertFlyoutFunction", func => {
      this.showCreateAlertFlyout = func;
    });
    (0, _defineProperty2.default)(this, "unsetShowCreateAlertFlyoutFunction", () => {
      this.showCreateAlertFlyout = () => {};
    });
    (0, _defineProperty2.default)(this, "getShowCreateAlertFlyoutFunction", () => {
      return this.showCreateAlertFlyout;
    });
    (0, _defineProperty2.default)(this, "selectJobChange", selectedJobs => {
      this.setState({
        selectedJobs
      });
    });
    (0, _defineProperty2.default)(this, "setFilters", async query => {
      if (query === null) {
        this.setState({
          filteredJobsSummaryList: this.state.jobsSummaryList,
          filterClauses: []
        }, () => {
          this.refreshSelectedJobs();
        });
        return;
      }
      this.props.onJobsViewStateUpdate({
        queryText: query === null || query === void 0 ? void 0 : query.text
      },
      // Replace the URL state on filters initialization
      this._isFiltersSet === false);
      const filterClauses = query && query.ast && query.ast.clauses || [];
      if (filterClauses.length === 0) {
        this.setState({
          filteredJobsSummaryList: this.state.jobsSummaryList,
          filterClauses
        }, () => {
          this.refreshSelectedJobs();
        });
        return;
      }
      const filteredJobsSummaryList = (0, _utils.filterJobs)(this.state.jobsSummaryList, filterClauses);
      this.setState({
        filteredJobsSummaryList,
        filterClauses
      }, () => {
        this.refreshSelectedJobs();
      });
      this._isFiltersSet = true;
    });
    (0, _defineProperty2.default)(this, "onRefreshClick", () => {
      this.setState({
        isRefreshing: true
      });
      this.refreshJobSummaryList();
    });
    (0, _defineProperty2.default)(this, "isDoneRefreshing", () => {
      this.setState({
        isRefreshing: false
      });
    });
    this.state = {
      isRefreshing: false,
      loading: null,
      jobsSummaryList: [],
      filteredJobsSummaryList: [],
      fullJobsList: {},
      selectedJobs: [],
      itemIdToExpandedRowMap: {},
      filterClauses: [],
      blockingJobIds: [],
      jobsAwaitingNodeCount: 0
    };
    this.updateFunctions = {};
    this.showEditJobFlyout = () => {};
    this.showDatafeedChartFlyout = () => {};
    this.showStopDatafeedsConfirmModal = () => {};
    this.showCloseJobsConfirmModal = () => {};
    this.showDeleteJobModal = () => {};
    this.showResetJobModal = () => {};
    this.showStartDatafeedModal = () => {};
    this.showCreateAlertFlyout = () => {};
    // work around to keep track of whether the component is mounted
    // used to block timeouts for results polling
    // which can run after unmounting
    this._isMounted = false;
    /**
     * Indicates if the filters has been initialized by {@link JobFilterBar} component
     * @type {boolean}
     * @private
     */
    this._isFiltersSet = false;
  }
  componentDidMount() {
    this._isMounted = true;
    this.refreshJobSummaryList();
    this.openAutoStartDatafeedModal();
  }
  componentDidUpdate(prevProps) {
    if (prevProps.lastRefresh !== this.props.lastRefresh) {
      this.setState({
        isRefreshing: true
      });
      this.refreshJobSummaryList();
    }
  }
  componentWillUnmount() {
    blockingJobsRefreshTimeout = null;
    this._isMounted = false;
  }
  openAutoStartDatafeedModal() {
    const job = (0, _utils.checkForAutoStartDatafeed)();
    if (job !== undefined) {
      this.showStartDatafeedModal([job]);
    }
  }
  refreshSelectedJobs() {
    var _this$state$filteredJ;
    const selectedJobsIds = this.state.selectedJobs.map(j => j.id);
    const filteredJobIds = ((_this$state$filteredJ = this.state.filteredJobsSummaryList) !== null && _this$state$filteredJ !== void 0 ? _this$state$filteredJ : []).map(j => j.id);

    // refresh the jobs stored as selected
    // only select those which are also in the filtered list
    const selectedJobs = this.state.jobsSummaryList.filter(j => selectedJobsIds.find(id => id === j.id)).filter(j => filteredJobIds.find(id => id === j.id));
    this.setState({
      selectedJobs
    });
  }
  async refreshJobSummaryList() {
    if (this._isMounted === false) {
      return;
    }

    // Set loading to true for jobs_list table for initial job loading
    if (this.state.loading === null) {
      this.setState({
        loading: true
      });
    }
    const expandedJobsIds = Object.keys(this.state.itemIdToExpandedRowMap);
    try {
      let jobsAwaitingNodeCount = 0;
      const jobs = await _ml_api_service.ml.jobs.jobsSummary(expandedJobsIds);
      const fullJobsList = {};
      const jobsSummaryList = jobs.map(job => {
        if (job.fullJob !== undefined) {
          if (this.props.showNodeInfo === false) {
            job.fullJob = (0, _job_utils.removeNodeInfo)(job.fullJob);
          }
          fullJobsList[job.id] = job.fullJob;
          delete job.fullJob;
        }
        job.latestTimestampSortValue = job.latestTimestampMs || 0;
        if (job.awaitingNodeAssignment === true) {
          jobsAwaitingNodeCount++;
        }
        return job;
      });
      const filteredJobsSummaryList = (0, _utils.filterJobs)(jobsSummaryList, this.state.filterClauses);
      this.setState({
        jobsSummaryList,
        filteredJobsSummaryList,
        fullJobsList,
        loading: false,
        jobsAwaitingNodeCount
      }, () => {
        this.refreshSelectedJobs();
      });
      Object.keys(this.updateFunctions).forEach(j => {
        this.updateFunctions[j](fullJobsList[j]);
      });
      this.isDoneRefreshing();
      if (blockingJobsRefreshTimeout === null && jobsSummaryList.some(j => j.blocked !== undefined)) {
        // if there are some jobs in a deleting state, start polling for
        // deleting jobs so we can update the jobs list once the
        // deleting tasks are over
        this.checkBlockingJobTasks(true);
      }
    } catch (error) {
      console.error(error);
      this.setState({
        loading: false
      });
    }
  }
  async checkBlockingJobTasks(forceRefresh = false) {
    if (this._isMounted === false) {
      return;
    }
    const {
      jobs
    } = await _ml_api_service.ml.jobs.blockingJobTasks();
    const blockingJobIds = jobs.map(j => Object.keys(j)[0]).sort();
    const taskListHasChanged = blockingJobIds.join() !== this.state.blockingJobIds.join();
    this.setState({
      blockingJobIds
    });

    // only reload the jobs list if the contents of the task list has changed
    // or the check refresh has been forced i.e. from a user action
    if (taskListHasChanged || forceRefresh) {
      this.refreshJobSummaryList();
    }
    if (blockingJobIds.length > 0 && blockingJobsRefreshTimeout === null) {
      blockingJobsRefreshTimeout = setTimeout(() => {
        blockingJobsRefreshTimeout = null;
        this.checkBlockingJobTasks();
      }, _jobs_list2.DELETING_JOBS_REFRESH_INTERVAL_MS);
    }
  }
  renderJobsListComponents() {
    const {
      isRefreshing,
      loading,
      jobsSummaryList,
      jobsAwaitingNodeCount
    } = this.state;
    const jobIds = jobsSummaryList.map(j => j.id);
    const noJobsFound = !loading && jobIds.length === 0;
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "ml-jobs-list"
    }, /*#__PURE__*/_react.default.createElement(_node_available_warning.NodeAvailableWarning, null), /*#__PURE__*/_react.default.createElement(_jobs_awaiting_node_warning.JobsAwaitingNodeWarning, {
      jobCount: jobsAwaitingNodeCount
    }), /*#__PURE__*/_react.default.createElement(_saved_objects_warning.SavedObjectsWarning, {
      onCloseFlyout: this.onRefreshClick,
      forceRefresh: loading || isRefreshing
    }), /*#__PURE__*/_react.default.createElement(_upgrade.UpgradeWarning, null), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, noJobsFound ? /*#__PURE__*/_react.default.createElement(_anomaly_detection_empty_state.AnomalyDetectionEmptyState, null) : null, jobIds.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_jobs_stats_bar.JobStatsBar, {
      jobsSummaryList: jobsSummaryList,
      showNodeInfo: this.props.showNodeInfo
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_new_job_button.NewJobButton, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      css: {
        alignItems: 'center',
        minHeight: '60px'
      },
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_multi_job_actions.MultiJobActions, {
      selectedJobs: this.state.selectedJobs,
      allJobIds: jobIds,
      showCloseJobsConfirmModal: this.showCloseJobsConfirmModal,
      showStartDatafeedModal: this.showStartDatafeedModal,
      showDeleteJobModal: this.showDeleteJobModal,
      showResetJobModal: this.showResetJobModal,
      showCreateAlertFlyout: this.showCreateAlertFlyout,
      showStopDatafeedsConfirmModal: this.showStopDatafeedsConfirmModal,
      refreshJobs: () => this.refreshJobSummaryList()
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_job_filter_bar.JobFilterBar, {
      setFilters: this.setFilters,
      queryText: this.props.jobsViewState.queryText
    }))), /*#__PURE__*/_react.default.createElement(_jobs_list.JobsList, {
      jobsSummaryList: this.state.filteredJobsSummaryList,
      fullJobsList: this.state.fullJobsList,
      itemIdToExpandedRowMap: this.state.itemIdToExpandedRowMap,
      toggleRow: this.toggleRow,
      selectJobChange: this.selectJobChange,
      showEditJobFlyout: this.showEditJobFlyout,
      showDatafeedChartFlyout: this.showDatafeedChartFlyout,
      showDeleteJobModal: this.showDeleteJobModal,
      showResetJobModal: this.showResetJobModal,
      showCloseJobsConfirmModal: this.showCloseJobsConfirmModal,
      showStartDatafeedModal: this.showStartDatafeedModal,
      showStopDatafeedsConfirmModal: this.showStopDatafeedsConfirmModal,
      refreshJobs: () => this.refreshJobSummaryList(),
      jobsViewState: this.props.jobsViewState,
      onJobsViewStateUpdate: this.props.onJobsViewStateUpdate,
      selectedJobsCount: this.state.selectedJobs.length,
      showCreateAlertFlyout: this.showCreateAlertFlyout,
      loading: loading
    }))) : null, /*#__PURE__*/_react.default.createElement(_edit_job_flyout.EditJobFlyout, {
      setShowFunction: this.setShowEditJobFlyoutFunction,
      unsetShowFunction: this.unsetShowEditJobFlyoutFunction,
      refreshJobs: () => this.refreshJobSummaryList(),
      allJobIds: jobIds
    }), /*#__PURE__*/_react.default.createElement(_datafeed_chart_flyout.JobListDatafeedChartFlyout, {
      setShowFunction: this.setShowDatafeedChartFlyoutFunction,
      unsetShowFunction: this.unsetShowDatafeedChartFlyoutFunction,
      refreshJobs: () => this.refreshJobSummaryList()
    }), /*#__PURE__*/_react.default.createElement(_stop_datafeeds_confirm_modal.StopDatafeedsConfirmModal, {
      setShowFunction: this.setShowStopDatafeedsConfirmModalFunction,
      unsetShowFunction: this.unsetShowStopDatafeedsConfirmModalFunction,
      refreshJobs: () => this.refreshJobSummaryList(),
      allJobIds: jobIds
    }), /*#__PURE__*/_react.default.createElement(_close_jobs_confirm_modal.CloseJobsConfirmModal, {
      setShowFunction: this.setShowCloseJobsConfirmModalFunction,
      unsetShowFunction: this.unsetShowCloseJobsConfirmModalFunction,
      refreshJobs: () => this.refreshJobSummaryList()
    }), /*#__PURE__*/_react.default.createElement(_delete_job_modal.DeleteJobModal, {
      setShowFunction: this.setShowDeleteJobModalFunction,
      unsetShowFunction: this.unsetShowDeleteJobModalFunction,
      refreshJobs: () => this.refreshJobSummaryList()
    }), /*#__PURE__*/_react.default.createElement(_reset_job_modal.ResetJobModal, {
      setShowFunction: this.setShowResetJobModalFunction,
      unsetShowFunction: this.unsetShowResetJobModalFunction,
      refreshJobs: () => this.refreshJobSummaryList()
    }), /*#__PURE__*/_react.default.createElement(_start_datafeed_modal.StartDatafeedModal, {
      setShowFunction: this.setShowStartDatafeedModalFunction,
      unsetShowFunction: this.unsetShowDeleteJobModalFunction,
      getShowCreateAlertFlyoutFunction: this.getShowCreateAlertFlyoutFunction,
      refreshJobs: () => this.refreshJobSummaryList()
    }), /*#__PURE__*/_react.default.createElement(_ml_alerting_flyout.JobListMlAnomalyAlertFlyout, {
      setShowFunction: this.setShowCreateAlertFlyoutFunction,
      unsetShowFunction: this.unsetShowCreateAlertFlyoutFunction,
      onSave: this.onRefreshClick
    })));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", null, this.renderJobsListComponents());
  }
}
exports.JobsListView = JobsListView;