"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobDetailsUI = exports.JobDetails = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _extract_job_details = require("./extract_job_details");
var _json_tab = require("./json_tab");
var _datafeed_preview_tab = require("./datafeed_preview_tab");
var _annotations_table = require("../../../../components/annotations/annotations_table");
var _datafeed_chart_flyout = require("../datafeed_chart_flyout");
var _annotation_flyout = require("../../../../components/annotations/annotation_flyout");
var _revert_model_snapshot_flyout = require("../../../../components/model_snapshots/revert_model_snapshot_flyout");
var _model_snapshots = require("../../../../components/model_snapshots");
var _forecasts_table = require("./forecasts_table");
var _job_details_pane = require("./job_details_pane");
var _job_messages_pane = require("./job_messages_pane");
var _public = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class JobDetailsUI extends _react.Component {
  constructor(props) {
    super(props);
    this.state = {
      datafeedChartFlyoutVisible: false,
      modelSnapshot: null,
      revertSnapshotFlyoutVisible: false
    };
    if (this.props.addYourself) {
      this.props.addYourself(props.jobId, j => this.updateJob(j));
    }
  }
  componentWillUnmount() {
    this.props.removeYourself(this.props.jobId);
  }
  updateJob(job) {
    this.setState({
      job
    });
  }
  render() {
    var _this$state$job;
    const job = (_this$state$job = this.state.job) !== null && _this$state$job !== void 0 ? _this$state$job : this.props.job;
    const {
      services: {
        http: {
          basePath
        }
      }
    } = this.props.kibana;
    if (job === undefined) {
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "job-loading-spinner",
        "data-test-subj": "mlJobDetails loading"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "l"
      }));
    } else {
      const {
        refreshJobList,
        showClearButton
      } = this.props;
      const {
        general,
        customUrl,
        node,
        calendars,
        detectors,
        influencers,
        analysisConfig,
        analysisLimits,
        dataDescription,
        customSettings,
        jobTags,
        datafeed,
        counts,
        modelSizeStats,
        jobTimingStats,
        datafeedTimingStats,
        alertRules
      } = (0, _extract_job_details.extractJobDetails)(job, basePath, refreshJobList);
      if (job.blocked === undefined) {
        datafeed.titleAction = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          onClick: () => this.setState({
            datafeedChartFlyoutVisible: true
          }),
          iconType: "visAreaStacked",
          size: "s"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.jobDetails.tabs.datafeed.viewCountsButtonText",
          defaultMessage: "View datafeed counts"
        }));
      }
      const tabs = [{
        id: 'job-settings',
        'data-test-subj': 'mlJobListTab-job-settings',
        name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.jobSettingsLabel', {
          defaultMessage: 'Job settings'
        }),
        content: /*#__PURE__*/_react.default.createElement(_job_details_pane.JobDetailsPane, {
          "data-test-subj": "mlJobDetails-job-settings",
          sections: [general, customSettings, customUrl, jobTags, node, calendars, alertRules]
        }),
        time: job.open_time
      }, {
        id: 'job-config',
        'data-test-subj': 'mlJobListTab-job-config',
        name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.jobConfigLabel', {
          defaultMessage: 'Job config'
        }),
        content: /*#__PURE__*/_react.default.createElement(_job_details_pane.JobDetailsPane, {
          "data-test-subj": "mlJobDetails-job-config",
          sections: [detectors, influencers, analysisConfig, analysisLimits, dataDescription]
        })
      }, {
        id: 'datafeed',
        'data-test-subj': 'mlJobListTab-datafeed',
        name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.datafeedLabel', {
          defaultMessage: 'Datafeed'
        }),
        content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_job_details_pane.JobDetailsPane, {
          "data-test-subj": "mlJobDetails-datafeed",
          sections: [datafeed, datafeedTimingStats]
        }), this.props.jobId && this.state.datafeedChartFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_datafeed_chart_flyout.DatafeedChartFlyout, {
          onClose: () => {
            this.setState({
              datafeedChartFlyoutVisible: false
            });
          },
          onModelSnapshotAnnotationClick: modelSnapshot => {
            this.setState({
              modelSnapshot,
              revertSnapshotFlyoutVisible: true,
              datafeedChartFlyoutVisible: false
            });
          },
          end: job.data_counts.latest_bucket_timestamp,
          jobId: this.props.jobId
        }) : null, this.state.revertSnapshotFlyoutVisible === true && this.state.modelSnapshot !== null ? /*#__PURE__*/_react.default.createElement(_revert_model_snapshot_flyout.RevertModelSnapshotFlyout, {
          snapshot: this.state.modelSnapshot,
          snapshots: [this.state.modelSnapshot],
          job: job,
          closeFlyout: () => {
            this.setState({
              revertSnapshotFlyoutVisible: false
            });
          },
          refresh: refreshJobList
        }) : null)
      }, {
        id: 'counts',
        'data-test-subj': 'mlJobListTab-counts',
        name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.countsLabel', {
          defaultMessage: 'Counts'
        }),
        content: /*#__PURE__*/_react.default.createElement(_job_details_pane.JobDetailsPane, {
          "data-test-subj": "mlJobDetails-counts",
          sections: [counts, modelSizeStats, jobTimingStats]
        })
      }, {
        id: 'json',
        'data-test-subj': 'mlJobListTab-json',
        name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.jsonLabel', {
          defaultMessage: 'JSON'
        }),
        content: /*#__PURE__*/_react.default.createElement(_json_tab.JsonPane, {
          job: job
        })
      }, {
        id: 'job-messages',
        'data-test-subj': 'mlJobListTab-job-messages',
        name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.jobMessagesLabel', {
          defaultMessage: 'Job messages'
        }),
        content: /*#__PURE__*/_react.default.createElement(_job_messages_pane.JobMessagesPane, {
          jobId: job.job_id,
          refreshJobList: refreshJobList,
          showClearButton: showClearButton
        })
      }];
      if (datafeed.items.length) {
        tabs.push({
          id: 'datafeed-preview',
          disabled: job.blocked !== undefined,
          'data-test-subj': 'mlJobListTab-datafeed-preview',
          name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.datafeedPreviewLabel', {
            defaultMessage: 'Datafeed preview'
          }),
          content: /*#__PURE__*/_react.default.createElement(_datafeed_preview_tab.DatafeedPreviewPane, {
            job: job
          })
        }, {
          id: 'forecasts',
          disabled: job.blocked !== undefined,
          'data-test-subj': 'mlJobListTab-forecasts',
          name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.forecastsLabel', {
            defaultMessage: 'Forecasts'
          }),
          content: /*#__PURE__*/_react.default.createElement(_forecasts_table.ForecastsTable, {
            job: job
          })
        });
      }
      tabs.push({
        id: 'annotations',
        disabled: job.blocked !== undefined,
        'data-test-subj': 'mlJobListTab-annotations',
        name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.annotationsLabel', {
          defaultMessage: 'Annotations'
        }),
        content: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_annotations_table.AnnotationsTable, {
          jobs: [job],
          refreshJobList: refreshJobList
        }), /*#__PURE__*/_react.default.createElement(_annotation_flyout.AnnotationFlyout, null))
      });
      tabs.push({
        id: 'modelSnapshots',
        disabled: job.blocked !== undefined,
        'data-test-subj': 'mlJobListTab-modelSnapshots',
        name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.modelSnapshotsLabel', {
          defaultMessage: 'Model snapshots'
        }),
        content: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_model_snapshots.ModelSnapshotTable, {
          job: job,
          refreshJobList: refreshJobList
        }))
      });
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "tab-contents",
        "data-test-subj": `mlJobListRowDetails details-${job.job_id}`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
        tabs: tabs,
        initialSelectedTab: tabs[0],
        onTabClick: () => {}
      }));
    }
  }
}
exports.JobDetailsUI = JobDetailsUI;
JobDetailsUI.propTypes = {
  jobId: _propTypes.default.string.isRequired,
  job: _propTypes.default.object,
  addYourself: _propTypes.default.func.isRequired,
  removeYourself: _propTypes.default.func.isRequired,
  refreshJobList: _propTypes.default.func
};
const JobDetails = (0, _public.withKibana)(JobDetailsUI);
exports.JobDetails = JobDetails;