"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Explorer = void 0;
exports.getDefaultPanelsState = getDefaultPanelsState;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _help_popover = require("../components/help_popover");
var _annotation_flyout = require("../components/annotations/annotation_flyout");
var _annotations_table = require("../components/annotations/annotations_table");
var _components = require("./components");
var _influencers_list = require("../components/influencers_list");
var _checkbox_showcharts = require("../components/controls/checkbox_showcharts");
var _job_selector = require("../components/job_selector");
var _select_interval = require("../components/controls/select_interval/select_interval");
var _select_severity = require("../components/controls/select_severity/select_severity");
var _explorer_query_bar = require("./components/explorer_query_bar/explorer_query_bar");
var _explorer_utils = require("./explorer_utils");
var _anomaly_timeline = require("./anomaly_timeline");
var _explorer_constants = require("./explorer_constants");
var _explorer_charts_container = require("./explorer_charts/explorer_charts_container");
var _anomalies_table = require("../components/anomalies_table/anomalies_table");
var _anomalies_map = require("./anomalies_map");
var _settings = require("../../../common/constants/settings");
var _anomaly_context_menu = require("./anomaly_context_menu");
var _toast_notification_service = require("../services/toast_notification_service");
var _kibana = require("../contexts/kibana");
var _anomaly_explorer_context = require("./anomaly_explorer_context");
var _storage = require("../../../common/types/storage");
var _alerts = require("./alerts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-ignore

// Explorer Charts
// @ts-ignore
// Anomalies Table
// @ts-ignore
// Anomalies Map
const ExplorerPage = ({
  children,
  jobSelectorProps,
  noInfluencersConfigured,
  influencers,
  filterActive,
  filterPlaceHolder,
  indexPattern,
  dataViews,
  queryString,
  updateLanguage
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
  style: {
    width: '100%'
  }
}, /*#__PURE__*/_react.default.createElement(_job_selector.JobSelector, jobSelectorProps), indexPattern && updateLanguage ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_explorer_query_bar.ExplorerQueryBar, {
  filterActive: !!filterActive,
  filterPlaceHolder: filterPlaceHolder,
  indexPattern: indexPattern,
  dataViews: dataViews,
  queryString: queryString,
  updateLanguage: updateLanguage
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
  margin: "none"
})) : null)), children);
function getDefaultPanelsState() {
  return {
    topInfluencers: {
      isCollapsed: false,
      size: 20
    },
    mainPage: {
      isCollapsed: false,
      size: 80
    }
  };
}
const Explorer = ({
  invalidTimeRangeError,
  showCharts,
  severity,
  stoppedPartitions,
  selectedJobsRunning,
  timefilter,
  timeBuckets,
  selectedCells,
  swimLaneSeverity,
  explorerState,
  overallSwimlaneData
}) => {
  var _tableData$anomalies, _tableData$anomalies2;
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const [anomalyExplorerPanelState, setAnomalyExplorerPanelState] = (0, _mlLocalStorage.useStorage)(_storage.ML_ANOMALY_EXPLORER_PANELS, {
    topInfluencers: {
      isCollapsed: false,
      size: 20
    },
    mainPage: {
      size: 80
    }
  });
  const topInfluencersPanelRef = (0, _react.useRef)(null);
  const collapseFn = (0, _react.useRef)();
  const panelsInitialized = (0, _react.useRef)(false);
  (0, _react.useEffect)(
  /**
   * Preserve collapsible panel state on page load.
   * TODO Remove when https://github.com/elastic/eui/issues/4736 is resolved.
   */
  function initTopInfluencersPanelCollapse() {
    if (panelsInitialized.current || !collapseFn.current || !topInfluencersPanelRef.current) return;
    panelsInitialized.current = true;
    if (anomalyExplorerPanelState.topInfluencers.isCollapsed) {
      setTimeout(() => {
        if (collapseFn.current) {
          collapseFn.current();
        }
      }, 0);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [collapseFn.current, panelsInitialized, topInfluencersPanelRef.current, anomalyExplorerPanelState]);
  const onPanelWidthChange = (0, _react.useCallback)(newSizes => {
    setAnomalyExplorerPanelState({
      mainPage: {
        size: newSizes.mainPage
      },
      topInfluencers: {
        ...anomalyExplorerPanelState.topInfluencers,
        size: newSizes.topInfluencers
      }
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [anomalyExplorerPanelState]);
  const onToggleCollapsed = (0, _react.useCallback)(() => {
    panelsInitialized.current = true;
    const isCurrentlyCollapsed = anomalyExplorerPanelState.topInfluencers.isCollapsed;
    if (isCurrentlyCollapsed) {
      setAnomalyExplorerPanelState({
        mainPage: {
          size: 80
        },
        topInfluencers: {
          size: 20,
          isCollapsed: !isCurrentlyCollapsed
        }
      });
      return;
    }
    setAnomalyExplorerPanelState({
      mainPage: anomalyExplorerPanelState.mainPage,
      topInfluencers: {
        ...anomalyExplorerPanelState.topInfluencers,
        isCollapsed: !isCurrentlyCollapsed
      }
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [anomalyExplorerPanelState]);
  const {
    displayWarningToast,
    displayDangerToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const {
    anomalyTimelineStateService,
    anomalyExplorerCommonStateService,
    chartsStateService,
    anomalyDetectionAlertsStateService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const htmlIdGen = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)(), []);
  const [language, updateLanguage] = (0, _react.useState)(_explorer_query_bar.DEFAULT_QUERY_LANG);
  const [sourceIndicesWithGeoFields, setSourceIndicesWithGeoFields] = (0, _react.useState)({});
  const [dataViews, setDataViews] = (0, _react.useState)();
  const filterSettings = (0, _useObservable.default)(anomalyExplorerCommonStateService.getFilterSettings$(), anomalyExplorerCommonStateService.getFilterSettings());
  const selectedJobs = (0, _useObservable.default)(anomalyExplorerCommonStateService.getSelectedJobs$(), anomalyExplorerCommonStateService.getSelectedJobs());
  const alertsData = (0, _useObservable.default)(anomalyDetectionAlertsStateService.anomalyDetectionAlerts$, []);
  const applyFilter = (0, _react.useCallback)((fieldName, fieldValue, action) => {
    const {
      filterActive,
      queryString
    } = filterSettings;
    const indexPattern = explorerState.indexPattern;
    let newQueryString = '';
    const operator = 'and ';
    const sanitizedFieldName = (0, _explorer_utils.escapeParens)(fieldName);
    const sanitizedFieldValue = (0, _explorer_utils.escapeDoubleQuotes)(fieldValue);
    if (action === _explorer_constants.FILTER_ACTION.ADD) {
      // Don't re-add if already exists in the query
      const queryPattern = (0, _explorer_utils.getQueryPattern)(fieldName, fieldValue);
      if (queryString.match(queryPattern) !== null) {
        return;
      }
      newQueryString = `${queryString ? `${queryString} ${operator}` : ''}${sanitizedFieldName}:"${sanitizedFieldValue}"`;
    } else if (action === _explorer_constants.FILTER_ACTION.REMOVE) {
      if (filterActive === false) {
        return;
      } else {
        newQueryString = (0, _explorer_utils.removeFilterFromQueryString)(queryString, sanitizedFieldName, sanitizedFieldValue);
      }
    }
    try {
      const {
        clearSettings,
        settings
      } = (0, _explorer_query_bar.getKqlQueryValues)({
        inputString: `${newQueryString}`,
        queryLanguage: language,
        indexPattern: indexPattern
      });
      if (clearSettings === true) {
        anomalyExplorerCommonStateService.clearFilterSettings();
      } else {
        anomalyExplorerCommonStateService.setFilterSettings(settings);
      }
    } catch (e) {
      console.log('Invalid query syntax from table', e); // eslint-disable-line no-console

      displayDangerToast(_i18n.i18n.translate('xpack.ml.explorer.invalidKuerySyntaxErrorMessageFromTable', {
        defaultMessage: 'Invalid syntax in query bar. The input must be valid Kibana Query Language (KQL)'
      }));
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [explorerState, language, filterSettings]);
  (0, _react.useEffect)(() => {
    if (invalidTimeRangeError) {
      displayWarningToast(_i18n.i18n.translate('xpack.ml.explorer.invalidTimeRangeInUrlCallout', {
        defaultMessage: 'The time filter was changed to the full range due to an invalid default time filter. Check the advanced settings for {field}.',
        values: {
          field: _settings.ANOMALY_DETECTION_DEFAULT_TIME_RANGE
        }
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const {
    services: {
      charts: chartsService,
      data: {
        dataViews: dataViewsService
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const mlLocator = (0, _kibana.useMlLocator)();
  const {
    annotations,
    filterPlaceHolder,
    indexPattern,
    influencers,
    loading,
    noInfluencersConfigured,
    tableData
  } = explorerState;
  const chartsData = (0, _useObservable.default)(chartsStateService.getChartsData$(), chartsStateService.getChartsData());
  const {
    filterActive,
    queryString
  } = filterSettings;
  const isOverallSwimLaneLoading = (0, _useObservable.default)(anomalyTimelineStateService.isOverallSwimLaneLoading$(), true);
  const isViewBySwimLaneLoading = (0, _useObservable.default)(anomalyTimelineStateService.isViewBySwimLaneLoading$(), true);
  const isDataLoading = loading || isOverallSwimLaneLoading || isViewBySwimLaneLoading;
  const swimLaneBucketInterval = (0, _useObservable.default)(anomalyTimelineStateService.getSwimLaneBucketInterval$(), anomalyTimelineStateService.getSwimLaneBucketInterval());
  const {
    annotationsData,
    totalCount: allAnnotationsCnt,
    error: annotationsError
  } = annotations;
  const annotationsCnt = Array.isArray(annotationsData) ? annotationsData.length : 0;
  const badge = (allAnnotationsCnt !== null && allAnnotationsCnt !== void 0 ? allAnnotationsCnt : 0) > annotationsCnt ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: 'hollow'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.annotationsOutOfTotalCountTitle",
    defaultMessage: "First {visibleCount} out of a total of {totalCount}",
    values: {
      visibleCount: annotationsCnt,
      totalCount: allAnnotationsCnt
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: 'hollow'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.annotationsTitleTotalCount",
    defaultMessage: "Total: {count}",
    values: {
      count: annotationsCnt
    }
  }));
  const jobSelectorProps = {
    dateFormatTz: (0, _explorer_utils.getDateFormatTz)()
  };
  const noJobsSelected = !selectedJobs || selectedJobs.length === 0;
  const hasResults = !!(overallSwimlaneData !== null && overallSwimlaneData !== void 0 && overallSwimlaneData.points) && overallSwimlaneData.points.length > 0;
  const hasResultsWithAnomalies = hasResults && overallSwimlaneData.points.some(v => v.value > 0) || ((_tableData$anomalies = tableData.anomalies) === null || _tableData$anomalies === void 0 ? void 0 : _tableData$anomalies.length) > 0;
  const hasActiveFilter = (0, _mlIsDefined.isDefined)(swimLaneSeverity);
  const selectedJobIds = Array.isArray(selectedJobs) ? selectedJobs.map(job => job.id) : [];
  (0, _react.useEffect)(() => {
    if (!noJobsSelected) {
      (0, _explorer_utils.getDataViewsAndIndicesWithGeoFields)(selectedJobs, dataViewsService).then(({
        sourceIndicesWithGeoFieldsMap,
        dataViews: dv
      }) => {
        setSourceIndicesWithGeoFields(sourceIndicesWithGeoFieldsMap);
        setDataViews(dv);
      }).catch(console.error); // eslint-disable-line no-console
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(selectedJobIds)]);
  if (noJobsSelected && !loading) {
    return /*#__PURE__*/_react.default.createElement(ExplorerPage, {
      dataViews: dataViews,
      jobSelectorProps: jobSelectorProps
    }, /*#__PURE__*/_react.default.createElement(_components.ExplorerNoJobsSelected, null));
  }
  if (!hasResultsWithAnomalies && !isDataLoading && !hasActiveFilter) {
    return /*#__PURE__*/_react.default.createElement(ExplorerPage, {
      dataViews: dataViews,
      jobSelectorProps: jobSelectorProps
    }, /*#__PURE__*/_react.default.createElement(_components.ExplorerNoResultsFound, {
      hasResults: hasResults,
      selectedJobsRunning: selectedJobsRunning
    }));
  }
  const bounds = timefilter.getActiveBounds();
  const mainPanelContent = /*#__PURE__*/_react.default.createElement("div", null, stoppedPartitions && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: 's',
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.stoppedPartitionsExistCallout",
      defaultMessage: "There may be fewer results than there could have been because stop_on_warn is turned on. Both categorization and subsequent anomaly detection have stopped for some partitions in {jobsWithStoppedPartitions, plural, one {job} other {jobs}} [{stoppedPartitions}] where the categorization status has changed to warn.",
      values: {
        jobsWithStoppedPartitions: stoppedPartitions.length,
        stoppedPartitions: stoppedPartitions.join(', ')
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_anomaly_timeline.AnomalyTimeline, {
    explorerState: explorerState
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), alertsData.length > 0 ? /*#__PURE__*/_react.default.createElement(_alerts.AlertsPanel, null) : null, annotationsError !== undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "mlAnomalyExplorerAnnotationsPanel error",
    size: 'xs'
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.annotationsErrorTitle",
    defaultMessage: "Annotations"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.explorer.annotationsErrorCallOutTitle', {
      defaultMessage: 'An error occurred loading annotations:'
    }),
    color: "danger",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, annotationsError))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), loading === false && (_tableData$anomalies2 = tableData.anomalies) !== null && _tableData$anomalies2 !== void 0 && _tableData$anomalies2.length ? /*#__PURE__*/_react.default.createElement(_anomalies_map.AnomaliesMap, {
    anomalies: tableData.anomalies,
    jobIds: selectedJobIds
  }) : null, annotationsCnt > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "mlAnomalyExplorerAnnotationsPanel loaded",
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: htmlIdGen(),
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      "data-test-subj": "mlAnomalyExplorerAnnotationsPanelButton",
      size: 'xs'
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.annotationsTitle",
      defaultMessage: "Annotations {badge}",
      values: {
        badge
      }
    })))
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_annotations_table.AnnotationsTable
  // @ts-ignore inferred js types are incorrect
  , {
    annotations: annotationsData,
    drillDown: true,
    numberBadge: false
  })))), /*#__PURE__*/_react.default.createElement(_annotation_flyout.AnnotationFlyout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), loading === false && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: 'xs'
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.anomaliesTitle",
    defaultMessage: "Anomalies"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      marginLeft: 'auto',
      alignSelf: 'baseline'
    }
  }, /*#__PURE__*/_react.default.createElement(_anomaly_context_menu.AnomalyContextMenu, {
    selectedJobs: selectedJobs,
    selectedCells: selectedCells,
    bounds: bounds,
    interval: swimLaneBucketInterval ? swimLaneBucketInterval.asSeconds() : undefined,
    chartsCount: chartsData.seriesToPlot.length
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l",
    responsive: true,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_select_severity.SelectSeverity, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_select_interval.SelectInterval, null)), chartsData.seriesToPlot.length > 0 && selectedCells !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_checkbox_showcharts.CheckboxShowCharts, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), showCharts ?
  /*#__PURE__*/
  // @ts-ignore inferred js types are incorrect
  _react.default.createElement(_explorer_charts_container.ExplorerChartsContainer, (0, _extends2.default)({}, chartsData, {
    severity,
    timefilter,
    mlLocator,
    timeBuckets,
    onSelectEntity: applyFilter,
    chartsService
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_anomalies_table.AnomaliesTable, {
    bounds: bounds,
    tableData: tableData,
    influencerFilter: applyFilter,
    sourceIndicesWithGeoFields: sourceIndicesWithGeoFields,
    selectedJobs: selectedJobs
  })));
  return /*#__PURE__*/_react.default.createElement(ExplorerPage, {
    dataViews: dataViews,
    jobSelectorProps: jobSelectorProps,
    noInfluencersConfigured: noInfluencersConfigured,
    influencers: influencers,
    filterActive: filterActive,
    filterPlaceHolder: filterPlaceHolder,
    indexPattern: indexPattern,
    queryString: queryString,
    updateLanguage: updateLanguage
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), noInfluencersConfigured ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 's'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.ml.explorer.noConfiguredInfluencersTooltip', {
      defaultMessage: 'The Top Influencers list is hidden because no influencers have been configured for the selected jobs.'
    }),
    position: "right",
    type: "iInCircle"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, mainPanelContent)) : /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, {
    direction: isMobile ? 'vertical' : 'horizontal',
    onPanelWidthChange: onPanelWidthChange
  }, (EuiResizablePanel, EuiResizableButton, actions) => {
    collapseFn.current = () => actions.togglePanel('topInfluencers', {
      direction: 'left'
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
      panelRef: topInfluencersPanelRef,
      id: 'topInfluencers',
      mode: ['collapsible', {
        'data-test-subj': 'mlTopInfluencersToggle',
        position: 'top'
      }],
      minSize: '200px',
      initialSize: 20,
      paddingSize: 'none',
      onToggleCollapsed: onToggleCollapsed
    }, /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "mlAnomalyExplorerInfluencerList",
      css: (0, _react2.css)`
                        padding: calc(${euiTheme.size.base} + ${euiTheme.border.width.thin})
                          ${euiTheme.size.l} ${euiTheme.size.l} 0;
                      `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "xs",
      responsive: false,
      alignItems: "baseline"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: 'xs'
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.topInfuencersTitle",
      defaultMessage: "Top influencers"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_help_popover.HelpPopover, {
      anchorPosition: "upCenter",
      title: _i18n.i18n.translate('xpack.ml.explorer.topInfluencersPopoverTitle', {
        defaultMessage: 'Top influencers'
      })
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.topInfluencersTooltip",
      defaultMessage: "View the relative impact of the top influencers in the selected time period and add them as filters on the results. Each influencer has a maximum anomaly score between 0-100 and a total anomaly score for that period."
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 'm'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 10,
      isLoading: loading
    }, /*#__PURE__*/_react.default.createElement(_influencers_list.InfluencersList, {
      influencers: influencers,
      influencerFilter: applyFilter
    })))), /*#__PURE__*/_react.default.createElement(EuiResizableButton, null), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
      id: "mainPage",
      mode: "main",
      minSize: '70%',
      initialSize: 80,
      paddingSize: 'none'
    }, mainPanelContent));
  })));
};
exports.Explorer = Explorer;