"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Controls = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _eui = require("@elastic/eui");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _cytoscape = require("./cytoscape");
var _locator = require("../../../../../../common/constants/locator");
var _check_capabilities = require("../../../../capabilities/check_capabilities");
var _kibana = require("../../../../contexts/kibana");
var _ml = require("../../../../contexts/ml");
var _index_utils = require("../../../../util/index_utils");
var _clone_action_name = require("../../analytics_management/components/action_clone/clone_action_name");
var _action_delete = require("../../analytics_management/components/action_delete");
var _delete_space_aware_item_check_modal = require("../../../../components/delete_space_aware_item_check_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getListItemsFactory(showLicenseInfo) {
  return details => {
    if (showLicenseInfo === false) {
      delete details.license_level;
    }
    return Object.entries(details).map(([key, value]) => {
      let description;
      if (key === 'create_time') {
        description = (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)((0, _momentTimezone.default)(value).unix() * 1000);
      } else {
        description = typeof value === 'object' ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          language: "json",
          fontSize: "s",
          paddingSize: "s"
        }, JSON.stringify(value, null, 2)) : value;
      }
      return {
        title: key,
        description
      };
    });
  };
}
const Controls = /*#__PURE__*/_react.default.memo(({
  details,
  getNodeData,
  modelId,
  refreshJobsCallback,
  updateElements
}) => {
  var _capabilities$managem, _capabilities$managem2;
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const [selectedNode, setSelectedNode] = (0, _react.useState)();
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const [didUntag, setDidUntag] = (0, _react.useState)(false);
  const canCreateDataFrameAnalytics = (0, _check_capabilities.usePermissionCheck)('canCreateDataFrameAnalytics');
  const canDeleteDataFrameAnalytics = (0, _check_capabilities.usePermissionCheck)('canDeleteDataFrameAnalytics');
  const deleteAction = (0, _action_delete.useDeleteAction)(canDeleteDataFrameAnalytics);
  const {
    showLicenseInfo
  } = (0, _ml.useEnabledFeatures)();
  const getListItems = (0, _react.useMemo)(() => getListItemsFactory(showLicenseInfo), [showLicenseInfo]);
  const {
    closeDeleteJobCheckModal,
    deleteItem,
    deleteTargetIndex,
    isModalVisible,
    isDeleteJobCheckModalVisible,
    item,
    jobType,
    openModal,
    openDeleteJobCheckModal
  } = deleteAction;
  const {
    services: {
      share,
      application: {
        navigateToUrl,
        capabilities
      }
    }
  } = (0, _kibana.useMlKibana)();
  const hasIngestPipelinesCapabilities = ((_capabilities$managem = capabilities.management) === null || _capabilities$managem === void 0 ? void 0 : (_capabilities$managem2 = _capabilities$managem.ingest) === null || _capabilities$managem2 === void 0 ? void 0 : _capabilities$managem2.ingest_pipelines) === true;
  const {
    toasts
  } = (0, _kibana.useNotifications)();
  const mlLocator = (0, _kibana.useMlLocator)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const navigateToWizardWithClonedJob = (0, _clone_action_name.useNavigateToWizardWithClonedJob)();
  const cy = (0, _react.useContext)(_cytoscape.CytoscapeContext);
  const deselect = (0, _react.useCallback)(() => {
    if (cy) {
      cy.elements().unselect();
    }
    setShowFlyout(false);
    setSelectedNode(undefined);
  }, [cy, setSelectedNode]);
  const nodeId = selectedNode === null || selectedNode === void 0 ? void 0 : selectedNode.data('id');
  const nodeLabel = selectedNode === null || selectedNode === void 0 ? void 0 : selectedNode.data('label');
  const nodeType = selectedNode === null || selectedNode === void 0 ? void 0 : selectedNode.data('type');
  const onCreateJobClick = (0, _react.useCallback)(async () => {
    const dataViewId = await (0, _index_utils.getDataViewIdFromName)(nodeLabel);
    if (dataViewId !== null) {
      const path = await mlLocator.getUrl({
        page: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_CREATE_JOB,
        pageState: {
          index: dataViewId
        }
      });
      await navigateToPath(path);
    } else {
      toasts.addDanger(_i18n.i18n.translate('xpack.ml.dataframe.analyticsMap.flyout.dataViewMissingMessage', {
        defaultMessage: 'To create a job from this index create a data view for {indexTitle}.',
        values: {
          indexTitle: nodeLabel
        }
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [nodeLabel]);
  const onManagePipeline = (0, _react.useCallback)(async () => {
    const ingestPipelineLocator = share.url.locators.get('INGEST_PIPELINES_APP_LOCATOR');
    if (ingestPipelineLocator && nodeLabel !== null) {
      const path = await ingestPipelineLocator.getUrl({
        page: 'pipeline_list'
      });

      // Passing pipelineId here because pipeline_list is not recognizing pipelineId params
      await navigateToUrl(`${path}/?pipeline=${nodeLabel}`);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [share.url.locators, nodeLabel]);
  const onAnalyzeDataDrift = (0, _react.useCallback)(async () => {
    closePopover();
    const path = await mlLocator.getUrl({
      page: _locator.ML_PAGES.DATA_DRIFT_CUSTOM,
      pageState: {
        comparison: nodeLabel
      }
    });
    await navigateToPath(path);
  }, [nodeLabel, navigateToPath, mlLocator]);
  const onCloneJobClick = (0, _react.useCallback)(async () => {
    var _details$nodeId;
    navigateToWizardWithClonedJob({
      config: details[nodeId],
      stats: (_details$nodeId = details[nodeId]) === null || _details$nodeId === void 0 ? void 0 : _details$nodeId.stats
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [nodeId]);
  const onActionsButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };

  // Set up Cytoscape event handlers
  (0, _react.useEffect)(() => {
    const selectHandler = event => {
      const targetNode = event.target;
      if (targetNode._private.data.type === _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.ANALYTICS_JOB_MISSING) {
        toasts.addWarning(_i18n.i18n.translate('xpack.ml.dataframe.analyticsMap.flyout.jobMissingMessage', {
          defaultMessage: 'There is no data available for job {label}.',
          values: {
            label: targetNode._private.data.label
          }
        }));
        return;
      }
      setSelectedNode(targetNode);
      setShowFlyout(true);
    };
    if (cy) {
      cy.on('select', 'node', selectHandler);
      cy.on('unselect', 'node', deselect);
    }
    return () => {
      if (cy) {
        cy.removeListener('select', 'node', selectHandler);
        cy.removeListener('unselect', 'node', deselect);
      }
    };
  }, [cy, deselect, toasts]);
  (0, _react.useEffect)(function updateElementsOnClose() {
    if (isModalVisible === false && deleteItem === true || didUntag === true) {
      let destIndexNode;
      if (deleteTargetIndex === true || didUntag === true) {
        const jobDetails = details[nodeId];
        const destIndex = jobDetails.dest.index;
        destIndexNode = `${destIndex}-${_mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.INDEX}`;
      }
      updateElements(nodeId, nodeLabel, destIndexNode);
      setShowFlyout(false);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [isModalVisible, deleteItem, didUntag]);
  if (showFlyout === false) {
    return null;
  }
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: onActionsButtonClick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsMap.flyout.nodeActionsButton",
    defaultMessage: "Node actions"
  }));
  const items = [...(nodeType === _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.ANALYTICS ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: `${nodeId}-delete`,
    icon: "trash",
    disabled: !canDeleteDataFrameAnalytics,
    onClick: () => {
      var _details$nodeId2;
      openDeleteJobCheckModal({
        config: details[nodeId],
        stats: (_details$nodeId2 = details[nodeId]) === null || _details$nodeId2 === void 0 ? void 0 : _details$nodeId2.stats
      });
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsMap.flyout.deleteJobButton",
    defaultMessage: "Delete job"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: `${nodeId}-clone`,
    icon: "copy",
    disabled: !canCreateDataFrameAnalytics,
    onClick: onCloneJobClick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsMap.flyout.cloneJobButton",
    defaultMessage: "Clone job"
  }))] : []), ...(nodeType === _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.INDEX ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    disabled: !canCreateDataFrameAnalytics,
    key: `${nodeId}-drift-data`,
    icon: "visTagCloud",
    onClick: onAnalyzeDataDrift
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsMap.flyout.analyzeDrift",
    defaultMessage: "Analyze data drift"
  }))] : []), ...(nodeType === _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.INDEX ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    disabled: !canCreateDataFrameAnalytics,
    key: `${nodeId}-create`,
    icon: "plusInCircle",
    onClick: onCreateJobClick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsMap.flyout.createJobButton",
    defaultMessage: "Create job from this index"
  }))] : []), ...(modelId !== nodeLabel && (nodeType === _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.ANALYTICS || nodeType === _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.INDEX) ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: `${nodeId}-fetch-related`,
    icon: "branch",
    onClick: () => {
      getNodeData({
        id: nodeLabel,
        type: nodeType
      });
      if (cy) {
        cy.elements().unselect();
      }
      setShowFlyout(false);
      setPopover(false);
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsMap.flyout.fetchRelatedNodesButton",
    defaultMessage: "Fetch related nodes"
  }))] : []), ...(modelId !== nodeLabel && nodeType === _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.INGEST_PIPELINE && hasIngestPipelinesCapabilities ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: `${nodeId}-view-pipeline`,
    icon: "pipelineApp",
    onClick: onManagePipeline
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsMap.flyout.viewIngestPipelineButton",
    defaultMessage: "View ingest pipeline"
  }))] : [])];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    size: "m",
    onClose: deselect,
    "data-test-subj": "mlAnalyticsJobMapFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    "data-test-subj": "mlDataFrameAnalyticsNodeDetailsTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsMap.flyoutHeaderTitle",
    defaultMessage: "Details for {type} {id}",
    values: {
      id: nodeLabel,
      type: nodeType
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "column",
    listItems: nodeType === 'index-pattern' ? getListItems(details[nodeId][nodeLabel]) : getListItems(details[nodeId])
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, nodeType !== _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.TRAINED_MODEL && items.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "s",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items
  })) : null)), isDeleteJobCheckModalVisible && item && /*#__PURE__*/_react.default.createElement(_delete_space_aware_item_check_modal.DeleteSpaceAwareItemCheckModal, {
    mlSavedObjectType: jobType,
    ids: [item.config.id],
    onCloseCallback: closeDeleteJobCheckModal,
    canDeleteCallback: () => {
      // Item will always be set by the time we open the delete modal
      openModal(deleteAction.item);
      closeDeleteJobCheckModal();
    },
    refreshJobsCallback: refreshJobsCallback,
    setDidUntag: setDidUntag
  }), isModalVisible && /*#__PURE__*/_react.default.createElement(_action_delete.DeleteActionModal, deleteAction));
});
exports.Controls = Controls;