"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleActionPanel = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _add_to_filter_list_link = require("./add_to_filter_list_link");
var _delete_rule_modal = require("./delete_rule_modal");
var _edit_condition_link = require("./edit_condition_link");
var _utils = require("../utils");
var _ml_api_service = require("../../../services/ml_api_service");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Panel with a description of a rule and a list of actions that can be performed on the rule.
 */

class RuleActionPanel extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "getEditRuleLink", () => {
      const {
        ruleIndex,
        setEditRuleIndex
      } = this.props;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => setEditRuleIndex(ruleIndex)
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleActionPanel.editRuleLinkText",
        defaultMessage: "Edit rule"
      }));
    });
    (0, _defineProperty2.default)(this, "getDeleteRuleLink", () => {
      const {
        ruleIndex,
        deleteRuleAtIndex
      } = this.props;
      return /*#__PURE__*/_react.default.createElement(_delete_rule_modal.DeleteRuleModal, {
        ruleIndex: ruleIndex,
        deleteRuleAtIndex: deleteRuleAtIndex
      });
    });
    (0, _defineProperty2.default)(this, "getQuickEditConditionLink", () => {
      // Returns the link to adjust the numeric value of a condition
      // if the rule has a single numeric condition.
      const conditions = this.rule.conditions;
      let link = null;
      if (this.rule.conditions !== undefined && conditions.length === 1) {
        link = /*#__PURE__*/_react.default.createElement(_edit_condition_link.EditConditionLink, {
          conditionIndex: 0,
          conditionValue: conditions[0].value,
          appliesTo: conditions[0].applies_to,
          anomaly: this.props.anomaly,
          updateConditionValue: this.updateConditionValue
        });
      }
      return link;
    });
    (0, _defineProperty2.default)(this, "getQuickAddToFilterListLink", () => {
      // Returns the link to add the partitioning field value of the anomaly to the filter
      // list used in the scope part of the rule.

      // Note componentDidMount performs the checks for the existence of scope and partitioning fields.
      const {
        anomaly,
        addItemToFilterList
      } = this.props;
      const scope = this.rule.scope;
      const partitionFieldName = Object.keys(scope)[0];
      const partitionFieldValue = anomaly.source[partitionFieldName];
      const filterId = scope[partitionFieldName].filter_id;

      // Partitioning field values stored under named field in anomaly record will be an array.
      return /*#__PURE__*/_react.default.createElement(_add_to_filter_list_link.AddToFilterListLink, {
        fieldValue: partitionFieldValue[0],
        filterId: filterId,
        addItemToFilterList: addItemToFilterList
      });
    });
    (0, _defineProperty2.default)(this, "updateConditionValue", (conditionIndex, value) => {
      const {
        job,
        anomaly,
        ruleIndex,
        updateRuleAtIndex
      } = this.props;
      const detector = job.analysis_config.detectors[anomaly.detectorIndex];
      const editedRule = (0, _lodash.cloneDeep)(detector.custom_rules[ruleIndex]);
      const conditions = editedRule.conditions;
      if (conditionIndex < conditions.length) {
        conditions[conditionIndex].value = value;
      }
      updateRuleAtIndex(ruleIndex, editedRule);
    });
    const {
      job: _job,
      anomaly: _anomaly,
      ruleIndex: _ruleIndex
    } = this.props;
    const _detector = _job.analysis_config.detectors[_anomaly.detectorIndex];
    const rules = _detector.custom_rules;
    if (rules !== undefined && _ruleIndex < rules.length) {
      this.rule = rules[_ruleIndex];
    }
    this.state = {
      showAddToFilterListLink: false
    };
  }
  componentDidMount() {
    // If the rule has a scope section with a single partitioning field key,
    // load the filter list to check whether to add a link to add the
    // anomaly partitioning field value to the filter list.
    const scope = this.rule.scope;
    if (scope !== undefined && Object.keys(scope).length === 1) {
      const partitionFieldName = Object.keys(scope)[0];
      const partitionFieldValue = this.props.anomaly.source[partitionFieldName];
      if (scope[partitionFieldName] !== undefined && partitionFieldValue !== undefined && partitionFieldValue.length === 1 && partitionFieldValue[0].length > 0) {
        const filterId = scope[partitionFieldName].filter_id;
        _ml_api_service.ml.filters.filters({
          filterId
        }).then(filter => {
          const filterItems = filter.items;
          if (filterItems.indexOf(partitionFieldValue[0]) === -1) {
            this.setState({
              showAddToFilterListLink: true
            });
          }
        }).catch(resp => {
          console.log(`Error loading filter ${filterId}:`, resp);
        });
      }
    }
  }
  render() {
    if (this.rule === undefined) {
      return null;
    }

    // Add items for the standard Edit and Delete links.
    const descriptionListItems = [{
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.ruleEditor.ruleActionPanel.ruleTitle",
        defaultMessage: "Rule"
      }),
      description: (0, _utils.buildRuleDescription)(this.rule, this.props.anomaly)
    }, {
      title: '',
      description: this.getEditRuleLink()
    }, {
      title: '',
      description: this.getDeleteRuleLink()
    }];

    // Insert links if applicable for quick edits to a numeric condition
    // or to the safe list used by the scope.
    const quickConditionLink = this.getQuickEditConditionLink();
    if (quickConditionLink !== null) {
      descriptionListItems.splice(1, 0, {
        title: '',
        description: quickConditionLink
      });
    }
    if (this.state.showAddToFilterListLink === true) {
      const quickAddToFilterListLink = this.getQuickAddToFilterListLink();
      descriptionListItems.splice(descriptionListItems.length - 2, 0, {
        title: '',
        description: quickAddToFilterListLink
      });
    }
    descriptionListItems[1].title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.ruleActionPanel.actionsTitle",
      defaultMessage: "Actions"
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      paddingSize: "m",
      className: "select-rule-action-panel"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      type: "column",
      columnWidths: [15, 85],
      listItems: descriptionListItems
    }));
  }
}
exports.RuleActionPanel = RuleActionPanel;
RuleActionPanel.propTypes = {
  job: _propTypes.default.object.isRequired,
  anomaly: _propTypes.default.object.isRequired,
  ruleIndex: _propTypes.default.number.isRequired,
  setEditRuleIndex: _propTypes.default.func.isRequired,
  updateRuleAtIndex: _propTypes.default.func.isRequired,
  deleteRuleAtIndex: _propTypes.default.func.isRequired,
  addItemToFilterList: _propTypes.default.func.isRequired
};