"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _ml = require("../../contexts/ml");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SyncList = ({
  syncItems
}) => {
  const {
    isADEnabled
  } = (0, _ml.useEnabledFeatures)();
  if (syncItems === null) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SavedObjectsCreated, {
    syncItems: syncItems
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  }), /*#__PURE__*/_react.default.createElement(SavedObjectsDeleted, {
    syncItems: syncItems
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  }), isADEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(DatafeedsAdded, {
    syncItems: syncItems
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  }), /*#__PURE__*/_react.default.createElement(DatafeedsRemoved, {
    syncItems: syncItems
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  })) : null);
};
exports.SyncList = SyncList;
const SavedObjectsCreated = ({
  syncItems
}) => {
  const count = getTotalItemsCount(syncItems.savedObjectsCreated);
  const title = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "mlJobMgmtSyncFlyoutMissingObjectsTitle"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: count ? 'default' : 'subdued'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.management.syncSavedObjectsFlyout.savedObjectsCreated.title",
    defaultMessage: "Missing saved objects ({count})",
    values: {
      count
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.management.syncSavedObjectsFlyout.savedObjectsCreated.description",
    defaultMessage: "If there are jobs that do not have accompanying saved objects, they will be created in the current space."
  })))));
  return /*#__PURE__*/_react.default.createElement(SyncItem, {
    id: "savedObjectsCreated",
    title: title,
    results: syncItems.savedObjectsCreated
  });
};
const SavedObjectsDeleted = ({
  syncItems
}) => {
  const count = getTotalItemsCount(syncItems.savedObjectsDeleted);
  const title = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "mlJobMgmtSyncFlyoutUnmatchedObjectsTitle"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: count ? 'default' : 'subdued'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.management.syncSavedObjectsFlyout.savedObjectsDeleted.title",
    defaultMessage: "Unmatched saved objects ({count})",
    values: {
      count
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.management.syncSavedObjectsFlyout.savedObjectsDeleted.description",
    defaultMessage: "If there are saved objects that do not have an accompanying job, they will be deleted."
  })))));
  return /*#__PURE__*/_react.default.createElement(SyncItem, {
    id: "savedObjectsDeleted",
    title: title,
    results: syncItems.savedObjectsDeleted
  });
};
const DatafeedsAdded = ({
  syncItems
}) => {
  const count = getTotalItemsCount(syncItems.datafeedsAdded);
  const title = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "mlJobMgmtSyncFlyoutObjectsMissingDatafeedTitle"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: count ? 'default' : 'subdued'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.management.syncSavedObjectsFlyout.datafeedsAdded.title",
    defaultMessage: "Saved objects with missing datafeeds ({count})",
    values: {
      count
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.management.syncSavedObjectsFlyout.datafeedsAdded.description",
    defaultMessage: "If there are saved objects that are missing the datafeed ID for anomaly detection jobs, the ID will be added."
  })))));
  return /*#__PURE__*/_react.default.createElement(SyncItem, {
    id: "datafeedsAdded",
    title: title,
    results: syncItems.datafeedsAdded
  });
};
const DatafeedsRemoved = ({
  syncItems
}) => {
  const count = getTotalItemsCount(syncItems.datafeedsRemoved);
  const title = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "mlJobMgmtSyncFlyoutObjectsUnmatchedDatafeedTitle"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: count ? 'default' : 'subdued'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.management.syncSavedObjectsFlyout.datafeedsRemoved.title",
    defaultMessage: "Saved objects with unmatched datafeed IDs ({count})",
    values: {
      count
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.management.syncSavedObjectsFlyout.datafeedsRemoved.description",
    defaultMessage: "If there are saved objects that use a datafeed that does not exist, they will be deleted."
  })))));
  return /*#__PURE__*/_react.default.createElement(SyncItem, {
    id: "datafeedsRemoved",
    title: title,
    results: syncItems.datafeedsRemoved
  });
};
const SyncItem = ({
  id,
  title,
  results
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: id,
    buttonContent: title,
    paddingSize: "l"
  }, Object.entries(results).map(([type, items]) => {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: type
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h4", null, type), /*#__PURE__*/_react.default.createElement("ul", null, Object.keys(items).map(item => /*#__PURE__*/_react.default.createElement("li", {
      key: item
    }, item)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }));
};
function getTotalItemsCount(result) {
  return Object.values(result).flatMap(r => Object.keys(r)).length;
}