"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSeverityOptions = exports.SelectSeverityUI = exports.SelectSeverity = exports.SEVERITY_OPTIONS = void 0;
exports.optionValueToThreshold = optionValueToThreshold;
exports.useTableSeverity = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlUrlState = require("@kbn/ml-url-state");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for rendering a select element with threshold levels.
 */

const warningLabel = _i18n.i18n.translate('xpack.ml.controls.selectSeverity.warningLabel', {
  defaultMessage: 'warning'
});
const minorLabel = _i18n.i18n.translate('xpack.ml.controls.selectSeverity.minorLabel', {
  defaultMessage: 'minor'
});
const majorLabel = _i18n.i18n.translate('xpack.ml.controls.selectSeverity.majorLabel', {
  defaultMessage: 'major'
});
const criticalLabel = _i18n.i18n.translate('xpack.ml.controls.selectSeverity.criticalLabel', {
  defaultMessage: 'critical'
});
const optionsMap = {
  [warningLabel]: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.LOW,
  [minorLabel]: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MINOR,
  [majorLabel]: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MAJOR,
  [criticalLabel]: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.CRITICAL
};
const SEVERITY_OPTIONS = [{
  val: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.LOW,
  display: warningLabel,
  color: (0, _mlAnomalyUtils.getSeverityColor)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.LOW)
}, {
  val: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MINOR,
  display: minorLabel,
  color: (0, _mlAnomalyUtils.getSeverityColor)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MINOR)
}, {
  val: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MAJOR,
  display: majorLabel,
  color: (0, _mlAnomalyUtils.getSeverityColor)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MAJOR)
}, {
  val: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.CRITICAL,
  display: criticalLabel,
  color: (0, _mlAnomalyUtils.getSeverityColor)(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.CRITICAL)
}];
exports.SEVERITY_OPTIONS = SEVERITY_OPTIONS;
function optionValueToThreshold(value) {
  // Get corresponding threshold object with required display and val properties from the specified value.
  let threshold = SEVERITY_OPTIONS.find(opt => opt.val === value);

  // Default to warning if supplied value doesn't map to one of the options.
  if (threshold === undefined) {
    threshold = SEVERITY_OPTIONS[0];
  }
  return threshold;
}
const TABLE_SEVERITY_DEFAULT = SEVERITY_OPTIONS[0];
const useTableSeverity = () => {
  return (0, _mlUrlState.usePageUrlState)('mlSelectSeverity', TABLE_SEVERITY_DEFAULT);
};
exports.useTableSeverity = useTableSeverity;
const getSeverityOptions = () => SEVERITY_OPTIONS.map(({
  color,
  display,
  val
}) => ({
  value: display,
  inputDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    style: {
      lineHeight: 'inherit'
    }
  }, display)),
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    style: {
      lineHeight: 'inherit'
    }
  }, display), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.controls.selectSeverity.scoreDetailsDescription",
    defaultMessage: "score {value} and above",
    values: {
      value: val
    }
  }))))
}));
exports.getSeverityOptions = getSeverityOptions;
const SelectSeverity = ({
  classNames
} = {
  classNames: ''
}) => {
  const [severity, setSeverity] = useTableSeverity();
  return /*#__PURE__*/_react.default.createElement(SelectSeverityUI, {
    severity: severity,
    onChange: setSeverity
  });
};
exports.SelectSeverity = SelectSeverity;
const SelectSeverityUI = ({
  classNames = '',
  severity,
  onChange,
  compressed
}) => {
  const handleOnChange = valueDisplay => {
    onChange(optionValueToThreshold(optionsMap[valueDisplay]));
  };
  const options = (0, _react.useMemo)(() => {
    return getSeverityOptions();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    prepend: _i18n.i18n.translate('xpack.ml.explorer.severityThresholdLabel', {
      defaultMessage: 'Severity'
    }),
    "data-test-subj": 'mlAnomalySeverityThresholdControls',
    className: classNames,
    hasDividers: true,
    options: options,
    valueOfSelected: severity.display,
    onChange: handleOnChange,
    compressed: true
  });
};
exports.SelectSeverityUI = SelectSeverityUI;