"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCapabilities = getCapabilities;
var _ml_api_service = require("../services/ml_api_service");
var _upgrade_service = require("../services/upgrade_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getCapabilities() {
  return new Promise((resolve, reject) => {
    _ml_api_service.ml.checkMlCapabilities().then(resp => {
      if (resp.upgradeInProgress === true) {
        (0, _upgrade_service.setUpgradeInProgress)(true);
      }
      resolve(resp);
    }).catch(() => {
      reject();
    });
  });
}