"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ML_ANOMALY_SEVERITY_TYPES = void 0;
var _i18n = require("@kbn/i18n");
var _anomaly_severity = require("./anomaly_severity");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ML_ANOMALY_SEVERITY_TYPES = {
  critical: {
    id: _anomaly_severity.ML_ANOMALY_SEVERITY.CRITICAL,
    label: _i18n.i18n.translate('xpack.ml.anomalyUtils.severity.criticalLabel', {
      defaultMessage: 'critical'
    })
  },
  major: {
    id: _anomaly_severity.ML_ANOMALY_SEVERITY.MAJOR,
    label: _i18n.i18n.translate('xpack.ml.anomalyUtils.severity.majorLabel', {
      defaultMessage: 'major'
    })
  },
  minor: {
    id: _anomaly_severity.ML_ANOMALY_SEVERITY.MINOR,
    label: _i18n.i18n.translate('xpack.ml.anomalyUtils.severity.minorLabel', {
      defaultMessage: 'minor'
    })
  },
  warning: {
    id: _anomaly_severity.ML_ANOMALY_SEVERITY.WARNING,
    label: _i18n.i18n.translate('xpack.ml.anomalyUtils.severity.warningLabel', {
      defaultMessage: 'warning'
    })
  },
  unknown: {
    id: _anomaly_severity.ML_ANOMALY_SEVERITY.UNKNOWN,
    label: _i18n.i18n.translate('xpack.ml.anomalyUtils.severity.unknownLabel', {
      defaultMessage: 'unknown'
    })
  },
  low: {
    id: _anomaly_severity.ML_ANOMALY_SEVERITY.LOW,
    label: _i18n.i18n.translate('xpack.ml.anomalyUtils.severityWithLow.lowLabel', {
      defaultMessage: 'low'
    })
  }
};
exports.ML_ANOMALY_SEVERITY_TYPES = ML_ANOMALY_SEVERITY_TYPES;