"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsDataClient = exports.DEFAULT_METRIC_INDICES = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/core/server");
var _metrics_data_source = require("../saved_objects/metrics_data_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_METRIC_INDICES = 'metrics-*,metricbeat-*';
exports.DEFAULT_METRIC_INDICES = DEFAULT_METRIC_INDICES;
class MetricsDataClient {
  constructor() {
    (0, _defineProperty2.default)(this, "defaultSavedObjectId", 'default');
    (0, _defineProperty2.default)(this, "getDefaultMetricIndices", null);
  }
  async getMetricIndices(options) {
    const metricIndices = await options.savedObjectsClient.get(_metrics_data_source.metricsDataSourceSavedObjectName, this.defaultSavedObjectId).then(({
      attributes
    }) => attributes.metricIndices).catch(err => {
      if (_server.SavedObjectsErrorHelpers.isNotFoundError(err)) {
        var _this$getDefaultMetri, _this$getDefaultMetri2;
        return (_this$getDefaultMetri = (_this$getDefaultMetri2 = this.getDefaultMetricIndices) === null || _this$getDefaultMetri2 === void 0 ? void 0 : _this$getDefaultMetri2.call(this, options)) !== null && _this$getDefaultMetri !== void 0 ? _this$getDefaultMetri : DEFAULT_METRIC_INDICES;
      }
      throw err;
    });
    return metricIndices;
  }
  async updateMetricIndices(options) {
    const object = await options.savedObjectsClient.create(_metrics_data_source.metricsDataSourceSavedObjectName, {
      metricIndices: options.metricIndices
    }, {
      id: this.defaultSavedObjectId,
      overwrite: true
    });
    return object;
  }
  setDefaultMetricIndicesHandler(handler) {
    this.getDefaultMetricIndices = handler;
  }
}
exports.MetricsDataClient = MetricsDataClient;