"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PodMetricsTable = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _shared = require("../shared");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PodMetricsTable = props => {
  const {
    data,
    isLoading,
    setCurrentPageIndex,
    setSortState,
    sortState,
    timerange
  } = props;
  const columns = (0, _react.useMemo)(() => podNodeColumns(timerange), [timerange]);
  const sorting = {
    enableAllColumns: true,
    sort: sortState
  };
  const onTableSortChange = ({
    sort = {
      direction: 'desc',
      field: 'averageCpuUsagePercent'
    }
  }) => {
    setSortState(sort);
    setCurrentPageIndex(0);
  };
  if (data.state === 'error') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, data.errors.map(error => /*#__PURE__*/_react.default.createElement(_shared.MetricsTableErrorContent, {
      error: error
    })));
  } else if (isLoading && data.state !== 'data') {
    return /*#__PURE__*/_react.default.createElement(_shared.MetricsTableLoadingContent, null);
  } else if (data.state === 'no-indices') {
    return /*#__PURE__*/_react.default.createElement(_shared.MetricsTableNoIndicesContent, null);
  } else if (data.state === 'empty-indices') {
    return /*#__PURE__*/_react.default.createElement(_shared.MetricsTableEmptyIndicesContent, null);
  } else if (data.state === 'data') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      tableCaption: _i18n.i18n.translate('xpack.metricsData.metricsTable.pod.tableCaption', {
        defaultMessage: 'Infrastructure metrics for pods'
      }),
      items: data.rows,
      columns: columns,
      sorting: sorting,
      onChange: onTableSortChange,
      loading: isLoading,
      noItemsMessage: /*#__PURE__*/_react.default.createElement(_shared.MetricsTableLoadingContent, null),
      "data-test-subj": "podMetricsTable"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      alignItems: "center",
      responsive: false,
      wrap: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_shared.StepwisePagination, {
      ariaLabel: _i18n.i18n.translate('xpack.metricsData.metricsTable.pod.paginationAriaLabel', {
        defaultMessage: 'Pod metrics pagination'
      }),
      pageCount: data.pageCount,
      currentPageIndex: data.currentPageIndex,
      setCurrentPageIndex: setCurrentPageIndex,
      "data-test-subj": "podMetricsTablePagination"
    }))));
  } else {
    return null;
  }
};
exports.PodMetricsTable = PodMetricsTable;
function podNodeColumns(timerange) {
  return [{
    name: _i18n.i18n.translate('xpack.metricsData.metricsTable.pod.nameColumnHeader', {
      defaultMessage: 'Name'
    }),
    field: 'name',
    truncateText: true,
    textOnly: true,
    render: (_, {
      id,
      name
    }) => {
      return /*#__PURE__*/_react.default.createElement(_shared.MetricsNodeDetailsLink, {
        id: id,
        label: name,
        nodeType: 'pod',
        timerange: timerange
      });
    }
  }, {
    name: _i18n.i18n.translate('xpack.metricsData.metricsTable.pod.averageCpuUsagePercentColumnHeader', {
      defaultMessage: 'CPU usage (avg.)'
    }),
    field: 'averageCpuUsagePercent',
    align: 'right',
    render: averageCpuUsagePercent => /*#__PURE__*/_react.default.createElement(_shared.NumberCell, {
      value: averageCpuUsagePercent,
      unit: "%"
    })
  }, {
    name: _i18n.i18n.translate('xpack.metricsData.metricsTable.pod.averageMemoryUsageMegabytesColumnHeader', {
      defaultMessage: 'Memory usage (avg.)'
    }),
    field: 'averageMemoryUsageMegabytes',
    align: 'right',
    render: averageMemoryUsageMegabytes => /*#__PURE__*/_react.default.createElement(_shared.NumberCell, {
      value: averageMemoryUsageMegabytes,
      unit: " MB"
    })
  }];
}