"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formulas = void 0;
var _node_cpu_capacity = require("./node_cpu_capacity");
var _node_cpu_used = require("./node_cpu_used");
var _node_disk_capacity = require("./node_disk_capacity");
var _node_disk_used = require("./node_disk_used");
var _node_memory_capacity = require("./node_memory_capacity");
var _node_memory_used = require("./node_memory_used");
var _node_pod_capacity = require("./node_pod_capacity");
var _node_pod_used = require("./node_pod_used");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formulas = {
  nodeCpuCapacity: _node_cpu_capacity.nodeCpuCapacity,
  nodeCpuUsed: _node_cpu_used.nodeCpuUsed,
  nodeDiskCapacity: _node_disk_capacity.nodeDiskCapacity,
  nodeDiskUsed: _node_disk_used.nodeDiskUsed,
  nodeMemoryCapacity: _node_memory_capacity.nodeMemoryCapacity,
  nodeMemoryUsed: _node_memory_used.nodeMemoryUsed,
  nodePodCapacity: _node_pod_capacity.nodePodCapacity,
  nodePodUsed: _node_pod_used.nodePodUsed
};
exports.formulas = formulas;