"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.waitUntilTimeLayersLoad$ = waitUntilTimeLayersLoad$;
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _map_selectors = require("../../../selectors/map_selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function waitUntilTimeLayersLoad$(store) {
  const reduxState$ = (0, _rxjs.from)(store);
  return reduxState$.pipe((0, _operators.debounceTime)(300),
  // using switchMap since switchMap will discard promise from previous state iterations in progress
  (0, _operators.switchMap)(async state => {
    const zoom = (0, _map_selectors.getMapZoom)(state);
    const promises = (0, _map_selectors.getLayerList)(state).map(async layer => {
      return {
        isFilteredByGlobalTime: await layer.isFilteredByGlobalTime(),
        layer,
        zoom
      };
    });
    const layersWithMeta = await Promise.all(promises);
    return layersWithMeta;
  }), (0, _operators.first)(layersWithMeta => {
    const areTimeLayersStillLoading = layersWithMeta.filter(({
      isFilteredByGlobalTime
    }) => isFilteredByGlobalTime).some(({
      layer,
      zoom
    }) => layer.isLayerLoading(zoom));
    return !areTimeLayersStillLoading;
  }), (0, _operators.map)(() => {
    // Observable notifies subscriber when loading is finished
    // Return void to not expose internal implemenation details of observabale
    return;
  }));
}