"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadListAndRender = LoadListAndRender;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _maps_list_view = require("./maps_list_view");
var _constants = require("../../../common/constants");
var _content_management = require("../../content_management");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LoadListAndRender(props) {
  const [mapsLoaded, setMapsLoaded] = (0, _react.useState)(false);
  const [hasSavedMaps, setHasSavedMaps] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    props.stateTransfer.clearEditorState(_constants.APP_ID);
    let ignore = false;
    (0, _content_management.getMapClient)().search({
      limit: 1
    }).then(results => {
      if (!ignore) {
        setHasSavedMaps(results.hits.length > 0);
        setMapsLoaded(true);
      }
    }).catch(err => {
      if (!ignore) {
        setMapsLoaded(true);
        setHasSavedMaps(false);
      }
    });
    return () => {
      ignore = true;
    };
    // only run on mount
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  if (!mapsLoaded) {
    // do not render loading state to avoid UI flash when listing page is displayed
    return null;
  }
  return hasSavedMaps ? /*#__PURE__*/_react.default.createElement(_maps_list_view.MapsListView, {
    history: props.history
  }) : /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: "/map"
  });
}