"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UtmForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class UtmForm extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_onZoneChange", evt => {
      this.setState({
        zone: _lodash.default.isNull(evt.target.value) ? '' : evt.target.value
      });
    });
    (0, _defineProperty2.default)(this, "_onEastingChange", evt => {
      this.setState({
        easting: _lodash.default.isNull(evt.target.value) ? '' : evt.target.value
      });
    });
    (0, _defineProperty2.default)(this, "_onNorthingChange", evt => {
      this.setState({
        northing: _lodash.default.isNull(evt.target.value) ? '' : evt.target.value
      });
    });
    (0, _defineProperty2.default)(this, "_onZoomChange", evt => {
      const sanitizedValue = parseFloat(evt.target.value);
      this.setState({
        zoom: isNaN(sanitizedValue) ? '' : sanitizedValue
      });
    });
    (0, _defineProperty2.default)(this, "_onSubmit", () => {
      const point = this._toPoint();
      if (point) {
        this.props.onSubmit(point.lat, point.lon, this.state.zoom);
      }
    });
    const utm = (0, _utils.ddToUTM)(this.props.center.lat, this.props.center.lon);
    this.state = {
      northing: utm.northing,
      easting: utm.easting,
      zone: utm.zone,
      zoom: this.props.zoom
    };
  }
  _toPoint() {
    const {
      northing,
      easting,
      zone
    } = this.state;
    return northing === '' || easting === '' || zone.length < 2 ? undefined : (0, _utils.utmToDD)(northing, easting, zone.substring(0, zone.length - 1));
  }
  _isUtmInvalid() {
    const point = this._toPoint();
    return point === undefined;
  }
  render() {
    const isUtmInvalid = this._isUtmInvalid();
    const northingError = isUtmInvalid || this.state.northing === '' ? _i18n.i18n.translate('xpack.maps.setViewControl.utmInvalidNorthing', {
      defaultMessage: 'UTM Northing is invalid'
    }) : null;
    const eastingError = isUtmInvalid || this.state.northing === '' ? _i18n.i18n.translate('xpack.maps.setViewControl.utmInvalidEasting', {
      defaultMessage: 'UTM Easting is invalid'
    }) : null;
    const zoneError = isUtmInvalid || this.state.northing === '' ? _i18n.i18n.translate('xpack.maps.setViewControl.utmInvalidZone', {
      defaultMessage: 'UTM Zone is invalid'
    }) : null;
    const {
      isInvalid: isZoomInvalid,
      error: zoomError
    } = (0, _utils.withinRange)(this.state.zoom, this.props.settings.minZoom, this.props.settings.maxZoom);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.setViewControl.utmZoneLabel', {
        defaultMessage: 'UTM Zone'
      }),
      isInvalid: isUtmInvalid,
      error: zoneError,
      display: "columnCompressed"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      compressed: true,
      value: this.state.zone,
      onChange: this._onZoneChange,
      isInvalid: isUtmInvalid,
      "data-test-subj": "utmZoneInput"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.setViewControl.utmEastingLabel', {
        defaultMessage: 'UTM Easting'
      }),
      isInvalid: isUtmInvalid,
      error: eastingError,
      display: "columnCompressed"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      compressed: true,
      value: this.state.easting,
      onChange: this._onEastingChange,
      isInvalid: isUtmInvalid,
      "data-test-subj": "utmEastingInput"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.setViewControl.utmNorthingLabel', {
        defaultMessage: 'UTM Northing'
      }),
      isInvalid: isUtmInvalid,
      error: northingError,
      display: "columnCompressed"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      compressed: true,
      value: this.state.northing,
      onChange: this._onNorthingChange,
      isInvalid: isUtmInvalid,
      "data-test-subj": "utmNorthingInput"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.setViewControl.zoomLabel', {
        defaultMessage: 'Zoom'
      }),
      isInvalid: isZoomInvalid,
      error: zoomError,
      display: "columnCompressed"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      compressed: true,
      value: this.state.zoom,
      onChange: this._onZoomChange,
      isInvalid: isZoomInvalid,
      "data-test-subj": "zoomInput"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
      textAlign: "right"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      fill: true,
      disabled: isUtmInvalid || isZoomInvalid,
      onClick: this._onSubmit,
      "data-test-subj": "submitViewButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.setViewControl.submitButtonLabel",
      defaultMessage: "Go"
    }))));
  }
}
exports.UtmForm = UtmForm;