"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrawFeatureControl = void 0;
var _reactRedux = require("react-redux");
var _draw_feature_control = require("./draw_feature_control");
var _actions = require("../../../../actions");
var _map_selectors = require("../../../../selectors/map_selectors");
var _ui_selectors = require("../../../../selectors/ui_selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  const editState = (0, _map_selectors.getEditState)(state);
  const editLayer = editState ? (0, _map_selectors.getLayerById)(editState.layerId, state) : undefined;
  return {
    drawShape: editState ? editState.drawShape : undefined,
    drawMode: (0, _ui_selectors.getDrawMode)(state),
    editLayer
  };
}
function mapDispatchToProps(dispatch) {
  return {
    addNewFeatureToIndex(geometries) {
      dispatch((0, _actions.addNewFeatureToIndex)(geometries));
    },
    deleteFeatureFromIndex(featureId) {
      dispatch((0, _actions.deleteFeatureFromIndex)(featureId));
    }
  };
}
const connected = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_draw_feature_control.DrawFeatureControl);
exports.DrawFeatureControl = connected;