"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JoinDocumentationPopover = JoinDocumentationPopover;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana_services = require("../../../../kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function JoinDocumentationPopover() {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "joinHelpPopover",
    anchorPosition: "leftCenter",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
      },
      iconType: "documentation",
      "aria-label": "Join documentation"
    }),
    isOpen: isPopoverOpen,
    closePopover: () => {
      setIsPopoverOpen(false);
    },
    repositionOnScroll: true,
    ownFocus: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.layerPanel.joinEditor.title",
    defaultMessage: "Joins"
  })), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    style: {
      maxWidth: '36em'
    }
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.joinDocs.intro",
    defaultMessage: "Joins add metrics to layer features for data driven styling and tooltip content."
  }), ' ', /*#__PURE__*/_react.default.createElement("i", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.joinDocs.noMatches",
    defaultMessage: "Layer features that do have a matches are not visible on the map."
  }))), /*#__PURE__*/_react.default.createElement("dl", null, /*#__PURE__*/_react.default.createElement("dt", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.joinDocs.termJoinTitle",
    defaultMessage: "Term join"
  })), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.joinDocs.termsJoinIntro",
    defaultMessage: "A term join uses a shared key to combine layer features with metrics from an Elasticsearch terms aggregation."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: (0, _kibana_services.getDocLinks)().links.maps.termJoinsExample,
    target: "_blank",
    external: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.joinDocs.linkLabel",
    defaultMessage: "Term join example"
  }))), /*#__PURE__*/_react.default.createElement("dt", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.joinDocs.spatialJoinTitle",
    defaultMessage: "Spatial join"
  })), /*#__PURE__*/_react.default.createElement("dd", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.joinDocs.spatialJoinIntro",
    defaultMessage: "A spatial join uses a geospatial relationship to combine layer features with metrics from an Elasticsearch geo query filters aggregation."
  })))))));
}